<?xml version="1.0" encoding="UTF-8"?>
<!--
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
-->
<!--+
    | XSL effectuant une transformation d'identité pour chaque concept. On force l'espace de nom "http://sdx.culture.fr/thesaurus/1.0" dont SDX a besoin. On devrait pouvoir le faire via Java (cf. LuceneThesaurusBuilder) pour que ce soit plus propre. (MP)
    +-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:thes="http://sdx.culture.fr/thesaurus/1.0"
    xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx">

  <xsl:template match="/*">

    <xsl:element name="concept" namespace="http://sdx.culture.fr/thesaurus/1.0">
      <xsl:attribute name="id"><xsl:value-of select="@id" /></xsl:attribute>
      <xsl:apply-templates select="*" mode="copy" />
    </xsl:element>

  </xsl:template>

  <xsl:template match="@* | text()" mode="copy">
    <xsl:copy><xsl:value-of select="." /></xsl:copy>
  </xsl:template>

  <xsl:template match="*" mode="copy">
    <xsl:element name="{local-name()}" namespace="http://sdx.culture.fr/thesaurus/1.0">
      <xsl:apply-templates select="@* | node()" mode="copy" />
    </xsl:element>
  </xsl:template>

</xsl:stylesheet>
