/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.pipeline.AbstractNodeBasedTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NodeCountTransformation
extends AbstractNodeBasedTransformation {
    public static final String PARAM_NAME_BOUNDS_ELEMENT = "transform:bounds-element";
    public static final String PARAM_NAME_COUNT_MODE = "transform:count-mode";
    public static final String PARAM_VALUE_ELEMENT = "element";
    public static final String PARAM_VALUE_ATTRIBUTE = "attribute";
    protected String _boundsElem = null;
    protected String _countMode = "element";
    protected boolean withinBoundsElem = false;
    protected Hashtable sortedCounters = new Hashtable();
    protected StringBuffer content = null;

    protected void setInternalParameters(Parameters params) {
        super.setInternalParameters(params);
        this._boundsElem = params.getParameter(PARAM_NAME_BOUNDS_ELEMENT, null);
        this._countMode = params.getParameter(PARAM_NAME_COUNT_MODE, PARAM_VALUE_ELEMENT);
    }

    protected NodeCounter prepareCounter(String uri, String loc, String raw, Attributes atts) {
        NodeCounter l_nodeCounter = null;
        String l_keyType = null;
        String l_nodeName = null;
        String l_nodeCountValue = null;
        String l_attributeValue = null;
        l_nodeName = super.elementIsParameter(uri, loc, raw, atts);
        if (Utilities.checkString(l_nodeName)) {
            l_keyType = PARAM_VALUE_ELEMENT;
            l_nodeCountValue = this.transParameters.getParameter(l_nodeName, null);
            this.content = new StringBuffer();
        }
        if (l_nodeName == null && atts != null) {
            l_nodeName = super.attributeIsParameter(uri, loc, raw, atts);
            if (Utilities.checkString(l_nodeName)) {
                l_keyType = PARAM_VALUE_ATTRIBUTE;
            }
            l_nodeCountValue = (String)this._attributesToTrack.get(l_nodeName);
            l_attributeValue = atts.getValue(l_nodeName);
            if (this._countMode.equals(PARAM_VALUE_ELEMENT)) {
                this.content = new StringBuffer();
            }
        }
        if (Utilities.checkString(l_nodeName)) {
            if (!this.sortedCounters.containsKey(l_nodeName)) {
                l_nodeCounter = new NodeCounter();
                l_nodeCounter._name = l_nodeName;
                l_nodeCounter._keyType = l_keyType;
                l_nodeCounter._countValue = l_nodeCountValue;
                this.sortedCounters.put(l_nodeName, l_nodeCounter);
            } else {
                l_nodeCounter = (NodeCounter)this.sortedCounters.get(l_nodeName);
            }
        }
        if (this._countMode.equals(PARAM_VALUE_ATTRIBUTE) && Utilities.checkString(l_nodeCountValue) && Utilities.checkString(l_attributeValue) && l_nodeCountValue.trim().equals(l_attributeValue)) {
            this.count(l_nodeCounter._name, l_attributeValue);
            this.content = null;
        }
        return l_nodeCounter;
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        super.startElement(uri, loc, raw, a);
        this.setCurrentElementProperties(uri, loc, raw, a);
        if (!this.withinBoundsElem) {
            if (this._boundsElem.equals(loc) || this._boundsElem.equals(raw) || this._boundsElem.equals(this._xpathString.getLocalXPath()) || this._boundsElem.equals(this._xpathString.getQualifiedXPath())) {
                this.resetFields();
                this.withinBoundsElem = true;
            }
        } else if (this.withinBoundsElem) {
            this.prepareCounter(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.withinBoundsElem) {
            if (this.content != null && this._countMode.equals(PARAM_VALUE_ELEMENT)) {
                String content = this.content.toString();
                NodeCounter l_nodeCounter = this.prepareCounter(uri, loc, raw, super.peekCurrentAttributes());
                String l_counterName = l_nodeCounter._name;
                if (!Utilities.checkString(l_nodeCounter._countValue) || l_nodeCounter._countValue.trim().equals(content.trim())) {
                    this.count(l_counterName, content);
                }
            }
            if (this._boundsElem.equals(loc) || this._boundsElem.equals(raw) || this._boundsElem.equals(this._xpathString.getLocalXPath()) || this._boundsElem.equals(this._xpathString.getQualifiedXPath())) {
                this.withinBoundsElem = false;
                this.sendSummary();
                this.resetFields();
            }
            this.content = null;
        }
        super.endElement(uri, loc, raw);
        this.resetCurrentElementProperties(uri, loc, raw);
    }

    protected void count(String counterName, String content) {
        if (this.sortedCounters.containsKey(counterName) && Utilities.checkString(content)) {
            NodeCounter l_nodeCounter = (NodeCounter)this.sortedCounters.get(counterName);
            TreeMap l_sortedOccurences = l_nodeCounter._sortedCounter;
            Object key = this.getKeyForContentType(content);
            Integer l_nodeCount = (Integer)l_sortedOccurences.get(key);
            if (l_nodeCount == null) {
                l_nodeCount = new Integer(1);
            } else {
                int count = l_nodeCount;
                l_nodeCount = new Integer(++count);
            }
            l_sortedOccurences.put(key, l_nodeCount);
        }
    }

    private Object getKeyForContentType(String content) {
        Object key = null;
        try {
            key = Integer.valueOf(content);
        }
        catch (NumberFormatException e) {
            key = content;
        }
        return key;
    }

    protected void sendSummary() throws SAXException {
        AttributesImpl atts1 = new AttributesImpl();
        atts1.addAttribute("", "bounds-element", "bounds-element", "CDATA", this._boundsElem);
        atts1.addAttribute("", "count-mode", "count-mode", "CDATA", this._countMode);
        super.startElement("", "node-counter", "transform:node-counter", (Attributes)atts1);
        Iterator counts = this.sortedCounters.keySet().iterator();
        while (counts.hasNext()) {
            NodeCounter nodeCounter = (NodeCounter)counts.next();
            AttributesImpl atts2 = new AttributesImpl();
            atts2.addAttribute("", "name", "name", "CDATA", nodeCounter._name);
            if (Utilities.checkString(nodeCounter._countValue)) {
                atts2.addAttribute("", "value", "value", "CDATA", nodeCounter._countValue);
            }
            super.startElement("", "node-count", "transform:node-count", (Attributes)atts2);
            Iterator countValues = nodeCounter._sortedCounter.keySet().iterator();
            while (countValues.hasNext()) {
                Object key = countValues.next();
                String l_keyType = nodeCounter._keyType;
                String countName = nodeCounter._name;
                String countValue = nodeCounter._countValue;
                String nodeValue = key.toString();
                String occurs = nodeCounter._sortedCounter.get(key).toString();
                char[] value = nodeValue.toCharArray();
                AttributesImpl atts3 = new AttributesImpl();
                atts3.addAttribute("", "value", "value", "CDATA", countValue);
                atts3.addAttribute("", "name", "name", "CDATA", countName);
                atts3.addAttribute("", "key-type", "key-type", "CDATA", l_keyType);
                atts3.addAttribute("", "occurs", "occurs", "CDATA", occurs);
                super.startElement("", "count", "transform:count", (Attributes)atts3);
                super.characters(value, 0, value.length);
                super.endElement("", "count", "transform:count");
            }
            super.endElement("", "node-count", "transform:node-count");
        }
        super.endElement("", "node-counter", "transform:node-counter");
    }

    protected void resetFields() {
        super.resetFields();
        this.withinBoundsElem = false;
        this.sortedCounters = new Hashtable();
        this.content = null;
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        super.characters(c, start, len);
        if (this.withinBoundsElem && this.content != null) {
            this.content.append(c, start, len);
        }
    }

    public void recycle() {
        super.recycle();
        this.resetFields();
    }

    protected class NodeCounter {
        String _keyType = "";
        String _name = "";
        String _countValue = "";
        TreeMap _sortedCounter = new TreeMap();

        protected NodeCounter() {
        }
    }
}

