/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.logging;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;

public class LoggingIndexation
extends AbstractSdxObject {
    public static final String CLASS_NAME_SUFFIX = "LoggingIndexation";
    public Logger logger;
    private Logger s_logger;
    private int level;
    protected String m_indexationID;
    protected long m_start;
    protected String m_startFormatedDate;
    protected long m_end;
    protected String m_endFormatedDate;
    protected int m_nbdocs;
    protected int m_nbDocsAdded;
    protected int m_nbDocsError;
    protected String m_dbid;
    protected String m_doc_id;
    protected int m_doc_nbsubdocs;
    protected int m_doc_nbattached;
    protected long m_doc_start;
    protected String m_doc_startFormatedDate;
    protected long m_doc_end;
    protected String m_doc_endFormatedDate;
    protected int m_doc_rank;
    protected String m_doc_subdocid;
    protected int m_doc_subdoc_rank;
    protected int m_doc_attached_rank;
    protected int m_steps;
    protected int m_step;
    protected Hashtable m_docsadded;
    protected Hashtable m_docserror;
    protected Hashtable m_docserror_msg;
    protected Hashtable m_docs_infos;
    protected Hashtable m_doc_infos;
    public String m_separator;
    public static final String DEFAULT_SEPARATOR = ";";
    protected String m_dateFormat;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.S z";
    public static int docMoreInfosOutput = 500;
    public static final int STEP_INDEXATION_INIT = 1;
    public static final int STEP_DOCUMENT_INDEXATION_START = 111;
    public static final int STEP_DOCUMENT_TRANSFORMATION = 1111;
    public static final int STEP_DOCUMENT_TRANSFORMATION_START = 11111;
    public static final int STEP_DOCUMENT_TRANSFORMATION_END = 111111;
    public static final int STEP_DOCUMENT_ADD = 112;
    public static final int STEP_DOCUMENT_ADD_SET_ID = 1121;
    public static final int STEP_DOCUMENT_ADD_STORE_ORIGINAL_DOCUMENT = 1122;
    public static final int STEP_DOCUMENT_ADD_ATTACHED_START = 1123;
    public static final int STEP_DOCUMENT_ADD_ATTACHED_ADD = 11231;
    public static final int STEP_DOCUMENT_ADD_ATTACHED_END = 11232;
    public static final int STEP_DOCUMENT_ADD_SUBDOCUMENTS_START = 1124;
    public static final int STEP_DOCUMENT_ADD_SUBDOCUMENTS_ADD = 11241;
    public static final int STEP_DOCUMENT_ADD_SUBDOCUMENTS_END = 11242;
    public static final int STEP_DOCUMENT_ADD_TO_SEARCH_INDEX = 1125;
    public static final int STEP_DOCUMENT_ADD_OAI_DELETED_RECORD = 1126;
    public static final int STEP_DOCUMENT_ADD_TO_REPOSITORY = 1127;
    public static final int STEP_DOCUMENT_ADD_UPDATE_METADATA = 1128;
    public static final int STEP_DOCUMENT_INDEXATION_END = 113;
    public static final int STEP_MERGE_BATCH_INDEX = 12;
    public static final int STEP_OPTIMIZE_DOCUMENT_BASE = 13;
    public static final int STEP_INDEXATION_END = 2;
    public static final String STEP_INDEXATION_INIT_STRING = "INDEXATION_INIT";
    public static final String STEP_DOCUMENT_INDEXATION_START_STRING = "DOCUMENT_INDEXATION_START";
    public static final String STEP_DOCUMENT_TRANSFORMATION_STRING = "DOCUMENT_TRANSFORMATION";
    public static final String STEP_DOCUMENT_TRANSFORMATION_START_STRING = "DOCUMENT_TRANSFORMATION_START";
    public static final String STEP_DOCUMENT_TRANSFORMATION_END_STRING = "DOCUMENT_TRANSFORMATION_END";
    public static final String STEP_DOCUMENT_ADD_STRING = "DOCUMENT_ADD";
    public static final String STEP_DOCUMENT_ADD_SET_ID_STRING = "DOCUMENT_ADD_SET_ID";
    public static final String STEP_DOCUMENT_ADD_STORE_ORIGINAL_DOCUMENT_STRING = "DOCUMENT_ADD_STORE_ORIGINAL_DOCUMENT";
    public static final String STEP_DOCUMENT_ADD_ATTACHED_START_STRING = "DOCUMENT_ADD_ATTACHED_START";
    public static final String STEP_DOCUMENT_ADD_ATTACHED_ADD_STRING = "DOCUMENT_ADD_ATTACHED_ADD";
    public static final String STEP_DOCUMENT_ADD_ATTACHED_END_STRING = "DOCUMENT_ADD_ATTACHED_END";
    public static final String STEP_DOCUMENT_ADD_SUBDOCUMENTS_START_STRING = "DOCUMENT_ADD_SUBDOCUMENTS_START";
    public static final String STEP_DOCUMENT_ADD_SUBDOCUMENTS_ADD_STRING = "DOCUMENT_ADD_SUBDOCUMENTS_ADD";
    public static final String STEP_DOCUMENT_ADD_SUBDOCUMENTS_END_STRING = "DOCUMENT_ADD_SUBDOCUMENTS_END";
    public static final String STEP_DOCUMENT_ADD_TO_SEARCH_INDEX_STRING = "DOCUMENT_ADD_TO_SEARCH_INDEX";
    public static final String STEP_DOCUMENT_ADD_OAI_DELETED_RECORD_STRING = "DOCUMENT_ADD_OAI_DELETED_RECORD";
    public static final String STEP_DOCUMENT_ADD_TO_REPOSITORY_STRING = "DOCUMENT_ADD_TO_REPOSITORY";
    public static final String STEP_DOCUMENT_ADD_UPDATE_METADATA_STRING = "DOCUMENT_ADD_UPDATE_METADATA";
    public static final String STEP_DOCUMENT_INDEXATION_END_STRING = "DOCUMENT_INDEXATION_END";
    public static final String STEP_MERGE_BATCH_INDEX_STRING = "MERGE_BATCH_INDEX";
    public static final String STEP_OPTIMIZE_DOCUMENT_BASE_STRING = "OPTIMIZE_DOCUMENT_BASE";
    public static final String STEP_INDEXATION_END_STRING = "INDEXATION_END";
    public static final int LEVEL_DEBUG = 10000;
    public static final int LEVEL_INFO = 1000;
    public static final int LEVEL_WARN = 100;
    public static final int LEVEL_ERROR = 10;
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_OFF = 0;
    public static final String LEVEL_DEBUG_STRING = "debug";
    public static final String LEVEL_ERROR_STRING = "error";
    public static final String LEVEL_INFO_STRING = "info";
    public static final String LEVEL_WARN_STRING = "warn";
    public static final String LEVEL_FATAL_STRING = "fatal_error";
    public static final String LEVEL_OFF_STRING = "off";

    public void configure(Configuration conf, String dbid, long start, int nbdocs, String indexationID, String separator) throws ConfigurationException {
        try {
            try {
                if (!Utilities.checkString(dbid)) {
                    String[] args = new String[]{conf.getLocation()};
                    throw new SDXException(this.s_logger, 50, args, null);
                }
                super.configure(conf);
                this.m_dbid = dbid;
                this.m_start = start != -1L ? start : System.currentTimeMillis();
                this.m_nbdocs = nbdocs >= 0 ? nbdocs : 0;
                this.m_nbDocsAdded = 0;
                this.m_nbDocsError = 0;
                this.m_indexationID = Utilities.checkString(indexationID) ? indexationID : start + "";
                this.m_separator = Utilities.checkString(separator) ? separator : DEFAULT_SEPARATOR;
                this.m_dateFormat = DEFAULT_DATE_FORMAT;
                this.m_step = 1;
                this.m_docsadded = new Hashtable(this.m_nbdocs);
                this.m_docserror = new Hashtable();
                this.m_docserror_msg = new Hashtable();
                this.m_docs_infos = new Hashtable(this.m_nbdocs);
                this.m_doc_infos = this.initDocInfos();
                this.m_startFormatedDate = Date.formatDate(new java.util.Date(start), this.m_dateFormat);
                try {
                    this.configureLogger();
                }
                catch (Exception e) {
                }
                Object var12_11 = null;
                conf = null;
                dbid = null;
                start = -1L;
                nbdocs = -1;
                indexationID = null;
                separator = null;
            }
            catch (SDXException sdxe) {
                throw new ConfigurationException(sdxe.getMessage(), sdxe.fillInStackTrace());
            }
            catch (ConfigurationException ce) {
                String[] args = new String[]{conf.getLocation()};
                args[0] = ce.getMessage();
                SDXException sdxe = new SDXException(this.s_logger, 50, args, ce);
                throw new ConfigurationException(sdxe.getMessage(), sdxe.fillInStackTrace());
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            conf = null;
            dbid = null;
            start = -1L;
            nbdocs = -1;
            indexationID = null;
            separator = null;
            throw throwable;
        }
    }

    private Hashtable initDocInfos() {
        Hashtable<String, String> m_hash = new Hashtable<String, String>(6);
        m_hash.put("id", "");
        m_hash.put("rank", "");
        m_hash.put("start", "");
        m_hash.put("end", "");
        m_hash.put("nbsubdocs", "");
        m_hash.put("nbattached", "");
        return m_hash;
    }

    public void setSteps() {
        this.m_steps = 2;
    }

    public void configureLogger() {
        this.s_logger = super.getLog();
        if (this.s_logger == null) {
            return;
        }
        String logid = "indexation";
        if (Utilities.checkString(this.m_dbid) && this.m_dbid.indexOf("..") == -1) {
            logid = logid + "." + this.m_dbid;
        }
        this.logger = this.s_logger.getChildLogger(logid);
        this.level = this.logger.isDebugEnabled() ? 10000 : (this.logger.isErrorEnabled() ? 10 : (this.logger.isInfoEnabled() ? 1000 : (this.logger.isWarnEnabled() ? 100 : (this.logger.isFatalErrorEnabled() ? 1 : 0))));
        if (this.s_logger.isDebugEnabled()) {
            LoggingUtils.logDebug(this.s_logger, "Configuration of the indexation logger " + logid + " at level " + this.getLevelString() + " for the document base " + this._id);
        }
        logid = null;
    }

    public String log() {
        if (this.logger == null) {
            this.configureLogger();
        }
        if (this.m_step <= this.level) {
            String msg = this.formatMessage();
            this.logInfo(msg);
            return msg;
        }
        return null;
    }

    public void logInfo(String message) {
        if (this.logger == null) {
            this.configureLogger();
        }
        if (this.logger != null && Utilities.checkString(message) && this.m_step <= this.level) {
            this.logger.fatalError(message);
        }
    }

    public String formatMessage() {
        String msg = this.m_indexationID + this.m_separator + (Utilities.checkString(this.m_dbid) ? this.m_dbid : "") + this.m_separator + (this.m_nbdocs > 0 ? this.m_nbdocs + "" : "") + this.m_separator + (Utilities.checkString(this.m_startFormatedDate) ? this.m_startFormatedDate : "") + this.m_separator + (Utilities.checkString(this.m_endFormatedDate) ? this.m_endFormatedDate : "") + this.m_separator + this.getStepString() + this.m_separator + (this.m_step > 0 ? this.m_step + "" : "") + this.m_separator + (this.m_doc_rank > 0 ? this.m_doc_rank + "" : "") + this.m_separator + (Utilities.checkString(this.m_doc_startFormatedDate) ? this.m_doc_startFormatedDate : "") + this.m_separator + (Utilities.checkString(this.m_doc_endFormatedDate) ? this.m_doc_endFormatedDate : "") + this.m_separator + (Utilities.checkString(this.m_doc_id) ? this.m_doc_id : "") + this.m_separator + (this.m_doc_nbattached > 0 ? this.m_doc_nbattached + "" : "") + this.m_separator + (this.m_doc_nbsubdocs > 0 ? this.m_doc_nbsubdocs + "" : "") + this.m_separator + (this.m_doc_attached_rank > 0 ? this.m_doc_attached_rank + "" : "") + this.m_separator + (this.m_doc_subdoc_rank > 0 ? this.m_doc_subdoc_rank + "" : "");
        return msg;
    }

    public void logAddedAndErrorDocs() {
        String msg = this.m_indexationID + this.m_separator + (Utilities.checkString(this.m_dbid) ? this.m_dbid : "") + this.m_separator + (this.m_nbdocs > 0 ? this.m_nbdocs + "" : "") + this.m_separator + (Utilities.checkString(this.m_startFormatedDate) ? this.m_startFormatedDate : "") + this.m_separator + (Utilities.checkString(this.m_endFormatedDate) ? this.m_endFormatedDate : "") + this.m_separator + "DOCS_IDS" + this.m_separator + this.m_nbDocsAdded + this.m_separator + this.m_nbDocsError + this.m_separator + this.m_docsadded.toString() + this.m_separator + this.m_docserror.toString();
        this.logInfo(msg);
    }

    public void logErrorsMessages() {
        String msg = this.m_indexationID + this.m_separator + (Utilities.checkString(this.m_dbid) ? this.m_dbid : "") + this.m_separator + (this.m_nbdocs > 0 ? this.m_nbdocs + "" : "") + this.m_separator + (Utilities.checkString(this.m_startFormatedDate) ? this.m_startFormatedDate : "") + this.m_separator + (Utilities.checkString(this.m_endFormatedDate) ? this.m_endFormatedDate : "") + this.m_separator + "ERROR_MESSAGES" + this.m_separator + this.m_docserror_msg.toString();
        this.logInfo(msg);
    }

    public void setSeparator(String s) {
        if (Utilities.checkString(s)) {
            this.m_separator = s;
        }
    }

    public String getSeparator() {
        return this.m_separator;
    }

    public void setDateFormat(String s) {
        if (Utilities.checkString(s)) {
            this.m_dateFormat = s;
        }
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public void setStep(int currentStep) {
        this.m_step = currentStep;
        this.log();
    }

    public int getCurrentStep() {
        return this.m_step;
    }

    public void setStart(long indexationStart) {
        this.m_start = indexationStart;
        this.m_startFormatedDate = Date.formatDate(new java.util.Date(this.m_start), this.m_dateFormat);
        this.setStep(1);
    }

    public long getStart() {
        return this.m_start;
    }

    public void setEnd(long indexationEnd) {
        this.m_end = indexationEnd;
        this.m_endFormatedDate = Date.formatDate(new java.util.Date(this.m_end), this.m_dateFormat);
        this.m_doc_end = -1L;
        this.m_doc_id = null;
        this.m_doc_attached_rank = -1;
        this.m_doc_subdoc_rank = -1;
        this.setStep(2);
        this.logAddedAndErrorDocs();
        this.logErrorsMessages();
    }

    public long getEnd() {
        return this.m_end;
    }

    public void setDocID(String docID) {
        this.m_doc_id = docID;
        this.m_doc_infos.put("id", docID);
        this.addAddedDoc(this.m_doc_rank, this.m_doc_id);
        this.setStep(1121);
    }

    public String getDocID() {
        return this.m_doc_id;
    }

    public void setDocRank(int docRank) {
        this.m_doc_rank = docRank;
        this.m_doc_infos = this.initDocInfos();
        this.m_doc_infos.put("rank", this.m_doc_rank + "");
        this.setDocStart(System.currentTimeMillis());
        this.setStep(111);
    }

    public int getDocRank() {
        return this.m_doc_rank;
    }

    public void addErrorDoc(int rank, String docid) {
        this.addErrorDoc(rank, docid, null, null);
    }

    public void addErrorDoc(int rank, String docid, String message, Exception e) {
        ++this.m_nbDocsError;
        this.m_docserror.put(rank + "", docid);
        this.m_doc_infos = null;
        this.m_docserror_msg.put(Utilities.checkString(docid) ? docid : rank + "", Utilities.checkString(message) ? message : e.getLocalizedMessage());
        this.setStep(113);
    }

    public Hashtable getErrorDocs() {
        return this.m_docserror;
    }

    public void addAddedDoc(int rank, String docid) {
        this.m_docsadded.put(rank + "", docid);
        ++this.m_nbDocsAdded;
    }

    public Hashtable getAddedDocs() {
        return this.m_docsadded;
    }

    public static int getDocMoreInfosOutput() {
        return docMoreInfosOutput;
    }

    public static void setDocMoreInfosOutput(int docMoreInfosOutput) {
        LoggingIndexation.docMoreInfosOutput = docMoreInfosOutput;
    }

    public void setDocStart(long docStart) {
        this.m_doc_start = docStart;
        this.m_doc_startFormatedDate = Date.formatDate(new java.util.Date(this.m_doc_start), this.m_dateFormat);
        this.m_doc_infos.put("start", this.m_doc_startFormatedDate);
        this.m_doc_end = -1L;
        this.m_doc_id = null;
        this.m_doc_attached_rank = -1;
        this.m_doc_subdoc_rank = -1;
    }

    public int getDocStart() {
        return this.m_doc_rank;
    }

    public void setDocEnd(long docEnd) {
        this.m_doc_end = docEnd;
        this.m_doc_endFormatedDate = Date.formatDate(new java.util.Date(this.m_doc_end), this.m_dateFormat);
        if (this.m_doc_infos != null) {
            this.m_doc_infos.put("end", this.m_doc_endFormatedDate);
            this.m_docs_infos.put(this.m_doc_rank + "", this.m_doc_infos);
        }
    }

    public long getDocEnd() {
        return this.m_doc_end;
    }

    public void setDocNbSubdocs(int nbsubdocs) {
        this.m_doc_nbsubdocs = nbsubdocs;
        this.m_doc_infos.put("nbsubdocs", nbsubdocs + "");
    }

    public int getDocNbSubdocs() {
        return this.m_doc_nbsubdocs;
    }

    public void setDocNbAttached(int nbattached) {
        this.m_doc_nbattached = nbattached;
        this.m_doc_infos.put("nbattached", nbattached + "");
        this.setStep(11231);
    }

    public int getDocNbAttached() {
        return this.m_doc_nbattached;
    }

    public void setDocSubdocRank(int subdocRank) {
        this.m_doc_subdoc_rank = subdocRank;
    }

    public int getDocSubdocRank() {
        return this.m_doc_subdoc_rank;
    }

    public void setDocAttachedRank(int attachedRank) {
        this.m_doc_attached_rank = attachedRank;
        this.setStep(11231);
    }

    public int getDocAttachedRank() {
        return this.m_doc_attached_rank;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelString() {
        String ret = null;
        switch (this.level) {
            case 10000: {
                ret = LEVEL_DEBUG_STRING;
                break;
            }
            case 1000: {
                ret = LEVEL_INFO_STRING;
                break;
            }
            case 10: {
                ret = LEVEL_ERROR_STRING;
                break;
            }
            case 100: {
                ret = LEVEL_WARN_STRING;
                break;
            }
            case 1: {
                ret = LEVEL_FATAL_STRING;
                break;
            }
            default: {
                ret = LEVEL_OFF_STRING;
            }
        }
        return ret;
    }

    public String getStepString() {
        String ret = null;
        switch (this.m_step) {
            case 1: {
                ret = STEP_INDEXATION_INIT_STRING;
                break;
            }
            case 2: {
                ret = STEP_INDEXATION_END_STRING;
                break;
            }
            case 13: {
                ret = STEP_OPTIMIZE_DOCUMENT_BASE_STRING;
                break;
            }
            case 12: {
                ret = STEP_MERGE_BATCH_INDEX_STRING;
                break;
            }
            case 111: {
                ret = STEP_DOCUMENT_INDEXATION_START_STRING;
                break;
            }
            case 113: {
                ret = STEP_DOCUMENT_INDEXATION_END_STRING;
                break;
            }
            case 11111: {
                ret = STEP_DOCUMENT_TRANSFORMATION_START_STRING;
                break;
            }
            case 111111: {
                ret = STEP_DOCUMENT_TRANSFORMATION_END_STRING;
                break;
            }
            case 112: {
                ret = STEP_DOCUMENT_ADD_STRING;
                break;
            }
            case 1121: {
                ret = STEP_DOCUMENT_ADD_SET_ID_STRING;
                break;
            }
            case 1127: {
                ret = STEP_DOCUMENT_ADD_TO_REPOSITORY_STRING;
                break;
            }
            case 1125: {
                ret = STEP_DOCUMENT_ADD_TO_SEARCH_INDEX_STRING;
                break;
            }
            case 1126: {
                ret = STEP_DOCUMENT_ADD_OAI_DELETED_RECORD_STRING;
                break;
            }
            case 1128: {
                ret = STEP_DOCUMENT_ADD_UPDATE_METADATA_STRING;
                break;
            }
            case 1122: {
                ret = STEP_DOCUMENT_ADD_STORE_ORIGINAL_DOCUMENT_STRING;
                break;
            }
            case 1123: {
                ret = STEP_DOCUMENT_ADD_ATTACHED_START_STRING;
                break;
            }
            case 11231: {
                ret = STEP_DOCUMENT_ADD_ATTACHED_ADD_STRING;
                break;
            }
            case 11232: {
                ret = STEP_DOCUMENT_ADD_ATTACHED_END_STRING;
                break;
            }
            case 1124: {
                ret = STEP_DOCUMENT_ADD_SUBDOCUMENTS_START_STRING;
                break;
            }
            case 11242: {
                ret = STEP_DOCUMENT_ADD_SUBDOCUMENTS_END_STRING;
                break;
            }
            case 11241: {
                ret = STEP_DOCUMENT_ADD_SUBDOCUMENTS_ADD_STRING;
                break;
            }
            default: {
                ret = this.m_step + "";
            }
        }
        return ret;
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        this.getXMLInformation();
        return true;
    }

    protected void initVolatileObjectsToSax() {
        this.getXMLInformation();
    }

    public void getXMLInformation() {
        String msg;
        String docid;
        Enumeration e;
        StringBuffer sb;
        this._xmlizable_objects.put("IndexationID", String.valueOf(this.m_indexationID));
        this._xmlizable_objects.put("sdxdbid", String.valueOf(this.m_dbid));
        this._xmlizable_objects.put("steps", String.valueOf(this.m_steps));
        this._xmlizable_objects.put("step", String.valueOf(this.getStepString()));
        this._xmlizable_objects.put("nb-docs-to-index", String.valueOf(this.m_nbdocs));
        this._xmlizable_objects.put("nb-docs-added", String.valueOf(this.m_nbDocsAdded));
        this._xmlizable_objects.put("nb-docs-error", String.valueOf(this.m_nbDocsError));
        this._xmlizable_objects.put("doc-rank", String.valueOf(this.m_doc_rank));
        this._xmlizable_objects.put("start", String.valueOf(this.m_startFormatedDate));
        this._xmlizable_objects.put("end", String.valueOf(this.m_endFormatedDate));
        this._xmlizable_objects.put("added-docs", String.valueOf(this.m_docsadded));
        if (this.m_docsadded != null && !this.m_docsadded.isEmpty()) {
            sb = new StringBuffer(this.m_docsadded.size());
            e = this.m_docsadded.keys();
            while (e.hasMoreElements()) {
                docid = (String)e.nextElement();
                if (sb.length() != 0) {
                    sb.append(this.m_separator);
                }
                sb.append(docid + "=" + (String)this.m_docsadded.get(docid));
            }
            this._xmlizable_objects.put("added-docs", sb.toString());
            sb = null;
            docid = null;
        }
        this._xmlizable_objects.put("error-docs", String.valueOf(this.m_docserror));
        if (this.m_docserror != null && !this.m_docserror.isEmpty()) {
            sb = new StringBuffer(this.m_docserror.size());
            e = this.m_docserror.keys();
            while (e.hasMoreElements()) {
                docid = (String)e.nextElement();
                msg = (String)this.m_docserror.get(docid);
                if (sb.length() != 0) {
                    sb.append(this.m_separator);
                }
                sb.append(docid + (Utilities.checkString(msg) ? "=" + msg : ""));
            }
            this._xmlizable_objects.put("error-docs", sb.toString());
            sb = null;
            msg = null;
            docid = null;
        }
        this._xmlizable_objects.put("doc-start", String.valueOf(this.m_doc_startFormatedDate));
        this._xmlizable_objects.put("doc-end", String.valueOf(this.m_doc_endFormatedDate));
        this._xmlizable_objects.put("doc-id", String.valueOf(this.m_doc_id));
        this._xmlizable_objects.put("doc-nbattached", String.valueOf(this.m_doc_nbattached));
        this._xmlizable_objects.put("doc-nbsubocs", String.valueOf(this.m_doc_nbsubdocs));
        this._xmlizable_objects.put("doc-attached_rank", String.valueOf(this.m_doc_attached_rank));
        this._xmlizable_objects.put("doc-subdoc_rank", String.valueOf(this.m_doc_subdoc_rank));
        if (this.m_nbdocs < docMoreInfosOutput && this.m_docs_infos != null && !this.m_docs_infos.isEmpty()) {
            e = this.m_docs_infos.keys();
            while (e.hasMoreElements()) {
                docid = (String)e.nextElement();
                this._xmlizable_objects.put("doc-more-infos-" + docid, this.m_docs_infos.get(docid).toString());
            }
            docid = null;
        } else if (this.m_nbdocs >= docMoreInfosOutput) {
            this._xmlizable_objects.put("message", "DOC_MORE_INFOS_OUTPUT");
        }
        if (this.m_docserror_msg != null && !this.m_docserror_msg.isEmpty()) {
            e = this.m_docserror_msg.keys();
            while (e.hasMoreElements()) {
                docid = (String)e.nextElement();
                msg = (String)this.m_docserror_msg.get(docid);
                if (Utilities.checkString(docid) && Utilities.checkString(msg)) {
                    this._xmlizable_objects.put("doc-error-info-" + docid, Utilities.checkString(docid) ? docid + "=" + msg : msg);
                }
                docid = null;
                msg = null;
            }
        }
        docid = null;
        msg = null;
        sb = null;
    }
}

