/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractConfigurableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class SessionPropagatorAction
extends AbstractConfigurableAction
implements ThreadSafe {
    private List defaults;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        Configuration[] dflts = conf.getChildren();
        if (dflts != null) {
            this.defaults = new ArrayList(dflts.length);
            for (int i = 0; i < dflts.length; ++i) {
                this.defaults.add(new Entry(dflts[i].getName(), dflts[i].getValue()));
            }
        } else {
            this.defaults = new ArrayList(0);
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Request req = ObjectModelHelper.getRequest(objectModel);
        HashMap<String, String> actionMap = new HashMap<String, String>();
        Session session = req.getSession(false);
        if (session == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No session object");
            }
            return null;
        }
        try {
            int i;
            String[] names = parameters.getNames();
            for (i = 0; i < names.length; ++i) {
                String sessionParamName = names[i];
                String value = parameters.getParameter(sessionParamName);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Propagating value " + value + " to session attribute " + sessionParamName);
                }
                session.setAttribute(sessionParamName, value);
                actionMap.put(sessionParamName, value);
            }
            for (i = 0; i < this.defaults.size(); ++i) {
                Entry entry = (Entry)this.defaults.get(i);
                if (actionMap.containsKey(entry.key)) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Propagating value " + entry.value + " to session attribute " + entry.key);
                }
                session.setAttribute(entry.key, entry.value);
                actionMap.put(entry.key, entry.value);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("All params propagated to session");
            }
            return Collections.unmodifiableMap(actionMap);
        }
        catch (Exception e) {
            this.getLogger().warn("exception: ", (Throwable)e);
            return null;
        }
    }

    private static class Entry {
        public String key = null;
        public String value = null;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

