/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;
import org.apache.cocoon.environment.Environment;

public final class PipelinesNode
extends SimpleParentProcessingNode
implements Composable,
Disposable {
    private ComponentManager manager;
    private ErrorHandlerHelper errorHandlerHelper = new ErrorHandlerHelper();

    public void compose(ComponentManager manager) {
        this.manager = manager;
        this.errorHandlerHelper.compose(manager);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.errorHandlerHelper.enableLogging(logger);
    }

    public void setErrorHandler(ProcessingNode node) {
        this.errorHandlerHelper.set500Handler(node);
    }

    public void setChildren(ProcessingNode[] nodes) {
        ((PipelineNode)nodes[nodes.length - 1]).setLast(true);
        super.setChildren(nodes);
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        context.recompose(this.manager);
        try {
            return this.invokeNodes(this.children, env, context);
        }
        catch (ConnectionResetException e) {
            throw e;
        }
        catch (Exception ex) {
            return this.errorHandlerHelper.invokeErrorHandler(ex, env, context);
        }
    }

    public void dispose() {
        if (this.manager instanceof Disposable) {
            ((Disposable)this.manager).dispose();
        }
        this.manager = null;
    }
}

