/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.util.List;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.xml.utils.URI;

public class CachedFontInfo
extends EmbedFontInfo {
    private static final long serialVersionUID = 240028291961081894L;
    private long lastModified = -1L;

    public static File getFileFromUrls(String[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            File fontFile;
            String urlStr = urls[i];
            if (urlStr == null) continue;
            if (urlStr.startsWith("file:")) {
                try {
                    URI uri = new URI(urlStr);
                    urlStr = uri.getPath();
                }
                catch (URI.MalformedURIException e) {
                    // empty catch block
                }
            }
            if (!(fontFile = new File(urlStr)).exists() || !fontFile.canRead()) continue;
            return fontFile;
        }
        return null;
    }

    public CachedFontInfo(String metricsFile, boolean kerning, List fontTriplets, String embedFile, long lastModified) {
        super(metricsFile, kerning, fontTriplets, embedFile);
        this.lastModified = lastModified;
    }

    public CachedFontInfo(EmbedFontInfo fontInfo) {
        super(fontInfo.metricsFile, fontInfo.kerning, fontInfo.fontTriplets, fontInfo.embedFile);
        File fontFile = CachedFontInfo.getFileFromUrls(new String[]{this.embedFile, this.metricsFile});
        if (fontFile != null) {
            this.lastModified = fontFile.lastModified();
        }
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String toString() {
        return super.toString() + ", lastModified=" + this.lastModified;
    }
}

