/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.List;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.table.EffRow;

class TableContentPosition
extends Position {
    public static final int FIRST_IN_ROWGROUP = 1;
    public static final int LAST_IN_ROWGROUP = 2;
    protected List gridUnitParts;
    protected EffRow row;
    protected int flags;

    protected TableContentPosition(LayoutManager lm, List gridUnitParts, EffRow row) {
        super(lm);
        this.gridUnitParts = gridUnitParts;
        this.row = row;
    }

    public boolean getFlag(int which) {
        return (this.flags & 1 << which) != 0;
    }

    public void setFlag(int which, boolean value) {
        this.flags = value ? (this.flags |= 1 << which) : (this.flags &= ~(1 << which));
    }

    public boolean generatesAreas() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("TableContentPosition:");
        sb.append(this.getIndex());
        sb.append("[");
        sb.append(this.row.getIndex()).append("/");
        sb.append(this.getFlag(1) ? "F" : "-");
        sb.append(this.getFlag(2) ? "L" : "-").append("]");
        sb.append("(");
        sb.append(this.gridUnitParts);
        sb.append(")");
        return sb.toString();
    }
}

