/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Diff
extends SvnCommand {
    private SVNUrl oldUrl = null;
    private SVNUrl newUrl = null;
    private File oldPath = null;
    private File newPath = null;
    private SVNRevision oldTargetRevision = null;
    private SVNRevision newTargetRevision = null;
    private File outFile = new File("patch");
    private boolean recurse = true;

    public void execute() throws SvnAntException {
        try {
            if (this.oldUrl != null) {
                this.svnClient.diff(this.oldUrl, this.oldTargetRevision, this.newUrl, this.newTargetRevision, this.outFile, this.recurse);
            } else {
                this.svnClient.diff(this.oldPath, this.oldTargetRevision, this.newPath, this.newTargetRevision, this.outFile, this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't get the differences", sVNClientException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.oldUrl != null ? this.oldPath != null || this.newPath != null : this.oldUrl != null || this.newUrl != null) {
            throw new SvnAntValidationException("paths cannot be with urls when diffing");
        }
    }

    public void setNewPath(File file) {
        this.newPath = file;
    }

    public void setNewTargetRevision(String string) {
        this.newTargetRevision = this.getRevisionFrom(string);
    }

    public void setNewUrl(SVNUrl sVNUrl) {
        this.newUrl = sVNUrl;
    }

    public void setOldPath(File file) {
        this.oldPath = file;
    }

    public void setOldTargetRevision(String string) {
        this.oldTargetRevision = this.getRevisionFrom(string);
    }

    public void setOldUrl(SVNUrl sVNUrl) {
        this.oldUrl = sVNUrl;
    }

    public void setOutFile(File file) {
        this.outFile = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

