/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.LinkedList;
import org.apache.cocoon.components.language.markup.LogicsheetFilter;
import org.apache.cocoon.components.language.markup.xsp.XSPExpressionParser;
import org.apache.cocoon.components.language.markup.xsp.XSPMarkupLanguage;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSPExpressionFilter
extends LogicsheetFilter
implements XSPExpressionParser.Handler {
    private String markupURI;
    private String markupPrefix;
    private LinkedList interpolationStack = new LinkedList();
    private InterpolationSettings defaultInterpolationSettings;
    private XSPExpressionParser expressionParser = new XSPExpressionParser(this);

    public XSPExpressionFilter(XSPMarkupLanguage markup) {
        this.markupURI = markup.getURI();
        this.markupPrefix = markup.getPrefix();
        this.defaultInterpolationSettings = new InterpolationSettings(markup.hasAttrInterpolation(), markup.hasTextInterpolation());
    }

    public void startDocument() throws SAXException {
        this.interpolationStack.clear();
        this.interpolationStack.addLast(this.defaultInterpolationSettings);
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attribs) throws SAXException {
        this.expressionParser.flush(this.locator, "...<" + qName + ">");
        attribs = this.pushInterpolationStack(attribs);
        if (this.getInterpolationSettings().attrInterpolation) {
            int i;
            AttributesImpl staticAttribs = new AttributesImpl();
            AttributesImpl dynamicAttribs = new AttributesImpl();
            for (i = 0; i < attribs.getLength(); ++i) {
                String value = attribs.getValue(i);
                if (value.indexOf("{#") != -1) {
                    dynamicAttribs.addAttribute(attribs.getURI(i), attribs.getLocalName(i), attribs.getQName(i), attribs.getType(i), value);
                    continue;
                }
                staticAttribs.addAttribute(attribs.getURI(i), attribs.getLocalName(i), attribs.getQName(i), attribs.getType(i), value);
            }
            super.startElement(namespaceURI, localName, qName, (Attributes)staticAttribs);
            for (i = 0; i < dynamicAttribs.getLength(); ++i) {
                AttributesImpl elemAttribs = new AttributesImpl();
                this.addAttribute(elemAttribs, "uri", dynamicAttribs.getURI(i));
                String qname = dynamicAttribs.getQName(i);
                if (qname != null) {
                    this.addAttribute(elemAttribs, "prefix", StringUtils.left((String)qname, (int)qname.indexOf(58)));
                }
                String attrName = dynamicAttribs.getLocalName(i);
                this.addAttribute(elemAttribs, "name", attrName);
                super.startElement(this.markupURI, "attribute", this.markupPrefix + ":attribute", (Attributes)elemAttribs);
                this.expressionParser.consume(dynamicAttribs.getValue(i));
                this.expressionParser.flush(this.locator, "<" + qName + " " + attrName + "=\"...\">");
                super.endElement(this.markupURI, "attribute", this.markupPrefix + ":attribute");
            }
        } else {
            super.startElement(namespaceURI, localName, qName, attribs);
        }
    }

    private Attributes pushInterpolationStack(Attributes attribs) {
        String valueAttr = attribs.getValue(this.markupURI, "attr-interpolation");
        String valueText = attribs.getValue(this.markupURI, "text-interpolation");
        if (valueAttr == null && valueText == null) {
            this.interpolationStack.addLast(this.interpolationStack.getLast());
            return attribs;
        }
        InterpolationSettings lastSettings = (InterpolationSettings)this.interpolationStack.getLast();
        boolean attrInterpolation = lastSettings.attrInterpolation;
        boolean textInterpolation = lastSettings.textInterpolation;
        AttributesImpl cleanedAttribs = new AttributesImpl(attribs);
        if (valueAttr != null) {
            attrInterpolation = Boolean.valueOf(valueAttr);
            cleanedAttribs.removeAttribute(cleanedAttribs.getIndex(this.markupURI, "attr-interpolation"));
        }
        if (valueText != null) {
            textInterpolation = Boolean.valueOf(valueText);
            cleanedAttribs.removeAttribute(cleanedAttribs.getIndex(this.markupURI, "text-interpolation"));
        }
        this.interpolationStack.addLast(new InterpolationSettings(attrInterpolation, textInterpolation));
        return cleanedAttribs;
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.expressionParser.flush(this.locator, "...</" + raw + ">");
        super.endElement(uri, loc, raw);
        this.interpolationStack.removeLast();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.getInterpolationSettings().textInterpolation) {
            this.expressionParser.consume(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    public void handleText(char[] chars, int start, int length) throws SAXException {
        super.characters(chars, start, length);
    }

    public void handleExpression(char[] chars, int start, int length) throws SAXException {
        super.startElement(this.markupURI, "expr", this.markupPrefix + ":expr", XMLUtils.EMPTY_ATTRIBUTES);
        super.characters(chars, start, length);
        super.endElement(this.markupURI, "expr", this.markupPrefix + ":expr");
    }

    protected void addAttribute(AttributesImpl attribs, String name, String value) {
        if (value != null && value.length() > 0) {
            attribs.addCDATAAttribute(name, value);
        }
    }

    private InterpolationSettings getInterpolationSettings() {
        return (InterpolationSettings)this.interpolationStack.getLast();
    }

    private static class InterpolationSettings {
        boolean attrInterpolation;
        boolean textInterpolation;

        InterpolationSettings(boolean attrInterpolation, boolean textInterpolation) {
            this.attrInterpolation = attrInterpolation;
            this.textInterpolation = textInterpolation;
        }
    }

    public static class XMLPipeAdapter
    extends AbstractXMLPipe {
        private XSPExpressionFilter expressionFilter;
        private AbstractXMLPipe additionalFilter;

        public XMLPipeAdapter(XSPExpressionFilter expressionFilter, AbstractXMLPipe additionalFilter) {
            this.additionalFilter = additionalFilter;
            this.expressionFilter = expressionFilter;
            super.setLexicalHandler((LexicalHandler)additionalFilter);
            super.setContentHandler((ContentHandler)expressionFilter);
            expressionFilter.setContentHandler((ContentHandler)additionalFilter);
        }

        public void setConsumer(XMLConsumer consumer) {
            this.additionalFilter.setConsumer(consumer);
        }

        public void setContentHandler(ContentHandler handler) {
            this.additionalFilter.setContentHandler(handler);
        }

        public void setLexicalHandler(LexicalHandler handler) {
            this.additionalFilter.setLexicalHandler(handler);
        }

        public void setDocumentLocator(Locator locator) {
            this.additionalFilter.setDocumentLocator(locator);
            this.expressionFilter.setDocumentLocator(locator);
        }
    }
}

