/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.access.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class MonitorAccess
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$access$monitor$MonitorAccess == null ? (class$org$apache$jcs$access$monitor$MonitorAccess = MonitorAccess.class$("org.apache.jcs.access.monitor.MonitorAccess")) : class$org$apache$jcs$access$monitor$MonitorAccess));
    protected CompositeCacheManager cacheMgr;
    static /* synthetic */ Class class$org$apache$jcs$access$monitor$MonitorAccess;
    static /* synthetic */ Class class$org$apache$jcs$access$GroupCacheAccess;

    public MonitorAccess() {
        Class clazz = class$org$apache$jcs$access$GroupCacheAccess == null ? (class$org$apache$jcs$access$GroupCacheAccess = MonitorAccess.class$("org.apache.jcs.access.GroupCacheAccess")) : class$org$apache$jcs$access$GroupCacheAccess;
        synchronized (clazz) {
            if (this.cacheMgr == null) {
                this.cacheMgr = CompositeCacheManager.getInstance();
            }
        }
    }

    public String delete(String cacheName, String key) {
        String result = "";
        try {
            CompositeCache cache = this.cacheMgr.getCache(cacheName);
            if (key != null) {
                if (key.toUpperCase().equals("ALL")) {
                    cache.removeAll();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removed all elements from " + cacheName));
                    }
                    result = "key = " + key;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("key = " + key));
                    }
                    result = "key = " + key;
                    StringTokenizer toke = new StringTokenizer(key, "_");
                    while (toke.hasMoreElements()) {
                        String temp = (String)toke.nextElement();
                        cache.remove((Serializable)((Object)key));
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Removed " + temp + " from " + cacheName));
                    }
                }
            } else {
                result = "key is null";
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return result;
    }

    public ArrayList overview() {
        ArrayList data = new ArrayList();
        Object[] list = this.cacheMgr.getCacheNames();
        Arrays.sort(list);
        int i = 0;
        while (i < list.length) {
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            Object name = list[i];
            ht.put("name", name);
            CompositeCache cache = this.cacheMgr.getCache((String)name);
            int size = cache.getSize();
            ht.put("size", Integer.toString(size));
            int status = cache.getStatus();
            String stat = status == 1 ? "ALIVE" : (status == 2 ? "DISPOSED" : (status == 3 ? "ERROR" : "UNKNOWN"));
            ht.put("stat", stat);
            data.add(ht);
            ++i;
        }
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

