/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

class MethodBinding
implements IMethodBinding {
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding;
    private BindingResolver resolver;
    private ITypeBinding[] parameterTypes;
    private ITypeBinding[] exceptionTypes;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding returnType;

    MethodBinding(BindingResolver resolver, org.eclipse.jdt.internal.compiler.lookup.MethodBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public boolean isConstructor() {
        return this.binding.isConstructor();
    }

    public boolean isDefaultConstructor() {
        if (this.binding.declaringClass.isBinaryBinding()) {
            return false;
        }
        return (this.binding.modifiers & 0x4000000) != 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.binding.isConstructor() ? this.getDeclaringClass().getName() : new String(this.binding.selector);
        }
        return this.name;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding.declaringClass);
        }
        return this.declaringClass;
    }

    public ITypeBinding[] getParameterTypes() {
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        TypeBinding[] parameters = this.binding.parameters;
        int length = parameters.length;
        if (length == 0) {
            return NO_TYPE_BINDINGS;
        }
        this.parameterTypes = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            this.parameterTypes[i] = this.resolver.getTypeBinding(parameters[i]);
            ++i;
        }
        return this.parameterTypes;
    }

    public ITypeBinding getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.resolver.getTypeBinding(this.binding.returnType);
        }
        return this.returnType;
    }

    public ITypeBinding[] getExceptionTypes() {
        if (this.exceptionTypes != null) {
            return this.exceptionTypes;
        }
        ReferenceBinding[] exceptions = this.binding.thrownExceptions;
        int length = exceptions.length;
        if (length == 0) {
            return NO_TYPE_BINDINGS;
        }
        this.exceptionTypes = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            this.exceptionTypes[i] = this.resolver.getTypeBinding(exceptions[i]);
            ++i;
        }
        return this.exceptionTypes;
    }

    public int getKind() {
        return 4;
    }

    public int getModifiers() {
        return this.binding.getAccessFlags();
    }

    public boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    public boolean isSynthetic() {
        return this.binding.isSynthetic();
    }

    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDeclaringClass().getKey());
        buffer.append('/');
        ITypeBinding _returnType = this.getReturnType();
        if (_returnType != null) {
            buffer.append(_returnType.getKey());
        }
        if (!this.isConstructor()) {
            buffer.append(this.getName());
        }
        ITypeBinding[] parameters = this.getParameterTypes();
        buffer.append('(');
        int i = 0;
        int max = parameters.length;
        while (i < max) {
            ITypeBinding parameter = parameters[i];
            if (parameter != null) {
                buffer.append(parameter.getKey());
            }
            ++i;
        }
        buffer.append(')');
        ITypeBinding[] thrownExceptions = this.getExceptionTypes();
        int i2 = 0;
        int max2 = thrownExceptions.length;
        while (i2 < max2) {
            if (thrownExceptions[i2] != null) {
                buffer.append(thrownExceptions[i2].getKey());
            }
            ++i2;
        }
        return buffer.toString();
    }

    public ITypeBinding[] getTypeParameters() {
        return NO_TYPE_BINDINGS;
    }

    public String toString() {
        return this.binding.toString();
    }
}

