/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class QuantifiedExpression
extends Assignation {
    private int operator;

    public void setOperator(int n) {
        this.operator = n;
    }

    public int getOperator() {
        return this.operator;
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.typeCheck(staticContext, itemType);
        if (Literal.isEmptySequence(this.sequence)) {
            return Literal.makeLiteral(BooleanValue.get(this.operator != 31));
        }
        Optimizer optimizer = staticContext.getConfiguration().getOptimizer();
        this.sequence = ExpressionTool.unsorted(optimizer, this.sequence, false);
        SequenceType sequenceType = this.declaration.getRequiredType();
        SequenceType sequenceType2 = SequenceType.makeSequenceType(sequenceType.getPrimaryType(), 57344);
        RoleLocator roleLocator = new RoleLocator(3, new Integer(this.nameCode), 0, staticContext.getNamePool());
        roleLocator.setSourceLocator(this);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType2, roleLocator, staticContext);
        ItemType itemType2 = this.sequence.getItemType(typeHierarchy);
        this.declaration.refineTypeInformation(itemType2, 16384, null, this.sequence.getSpecialProperties(), staticContext);
        this.declaration = null;
        this.action = this.action.typeCheck(staticContext, itemType);
        XPathException xPathException = TypeChecker.ebvError(this.action, staticContext.getConfiguration().getTypeHierarchy());
        if (xPathException != null) {
            xPathException.setLocator(this);
            throw xPathException;
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.sequence = this.sequence.optimize(optimizer, staticContext, itemType);
        this.action = this.action.optimize(optimizer, staticContext, itemType);
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.containingExpression = this;
        promotionOffer.action = 11;
        Binding[] bindingArray = new Binding[]{this};
        promotionOffer.bindingList = bindingArray;
        this.action = this.doPromotion(this.action, promotionOffer);
        if (promotionOffer.containingExpression instanceof LetExpression) {
            promotionOffer.containingExpression = promotionOffer.containingExpression.typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
        }
        return promotionOffer.containingExpression;
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        return n | 0x400000;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item;
        boolean bl;
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        boolean bl2 = bl = this.operator == 31;
        while ((item = sequenceIterator.next()) != null) {
            xPathContext.setLocalVariable(this.slotNumber, item);
            if (bl != this.action.effectiveBooleanValue(xPathContext)) continue;
            return bl;
        }
        return !bl;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + Token.tokens[this.operator] + " $" + this.getVariableName() + " in");
        this.sequence.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "satisfies");
        this.action.display(n + 1, printStream, configuration);
    }
}

