/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class VariableReference
extends Expression
implements BindingReference {
    Binding binding = null;
    SequenceType staticType = null;
    Value constantValue = null;
    transient String displayName = null;

    public VariableReference() {
    }

    public VariableReference(VariableDeclaration variableDeclaration) {
        variableDeclaration.registerReference(this);
        this.displayName = variableDeclaration.getVariableName();
    }

    public VariableReference copy() {
        VariableReference variableReference = new VariableReference();
        variableReference.binding = this.binding;
        variableReference.staticType = this.staticType;
        variableReference.constantValue = this.constantValue;
        variableReference.displayName = this.displayName;
        return variableReference;
    }

    public void setStaticType(SequenceType sequenceType, Value value, int n) {
        this.staticType = sequenceType;
        this.constantValue = value;
        this.staticProperties = n & 0xFFFEFFFF | sequenceType.getCardinality() | this.getDependencies();
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        if (this.staticType == null) {
            throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        return this;
    }

    public void fixup(Binding binding) {
        this.binding = binding;
        this.resetStaticProperties();
    }

    public void refineVariableReference() {
        if (this.binding instanceof Assignation || this.binding instanceof LocalParam || this.binding instanceof UserFunctionParameter) {
            int n = this.binding.getLocalSlotNumber();
            if (n < 0) {
                return;
            }
            LocalVariableReference localVariableReference = new LocalVariableReference(n);
            localVariableReference.binding = this.binding;
            localVariableReference.staticType = this.staticType;
            localVariableReference.displayName = this.displayName;
            localVariableReference.setParentExpression(this.getParentExpression());
            localVariableReference.setLocationId(this.getLocationId());
            boolean bl = this.getParentExpression().replaceSubExpression(this, localVariableReference);
            if (!bl) {
                throw new IllegalStateException("Child expression not found in parent");
            }
        }
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        if (this.staticType == null) {
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            return 57344;
        }
        return this.staticType.getCardinality();
    }

    public int computeSpecialProperties() {
        int n = super.computeSpecialProperties();
        if (this.binding == null || !this.binding.isAssignable()) {
            n |= 0x400000;
        }
        if (this.staticType != null && !Cardinality.allowsMany(this.staticType.getCardinality()) && this.staticType.getPrimaryType() instanceof NodeTest) {
            n |= 0x800000;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof VariableReference && this.binding == ((VariableReference)object).binding && this.binding != null;
    }

    public int hashCode() {
        return this.binding == null ? 73619830 : this.binding.hashCode();
    }

    public int getIntrinsicDependencies() {
        if (this.binding == null || !this.binding.isGlobal()) {
            return 128;
        }
        return 0;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression;
        if (promotionOffer.action == 12 && (expression = promotionOffer.accept(this)) != null) {
            promotionOffer.accepted = true;
            return expression;
        }
        return this;
    }

    public int getImplementationMethod() {
        return 7;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        try {
            ValueRepresentation valueRepresentation = this.evaluateVariable(xPathContext);
            return Value.getIterator(valueRepresentation);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            ValueRepresentation valueRepresentation = this.evaluateVariable(xPathContext);
            if (valueRepresentation instanceof Item) {
                return (Item)valueRepresentation;
            }
            return Value.asItem(valueRepresentation);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    public void process(XPathContext xPathContext) throws XPathException {
        try {
            ValueRepresentation valueRepresentation = this.evaluateVariable(xPathContext);
            if (valueRepresentation instanceof NodeInfo) {
                valueRepresentation = new SingletonNode((NodeInfo)valueRepresentation);
            }
            ((Value)valueRepresentation).process(xPathContext);
        }
        catch (XPathException xPathException) {
            if (xPathException.getLocator() == null || xPathException.getLocator().getLineNumber() == -1) {
                xPathException.setLocator(this);
            }
            throw xPathException;
        }
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) throws XPathException {
        return this.binding.evaluateVariable(xPathContext);
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        if (this.displayName != null) {
            printStream.println(ExpressionTool.indent(n) + '$' + this.displayName);
        } else {
            printStream.println(ExpressionTool.indent(n) + "$(unbound variable)");
        }
    }
}

