/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public class EnvironmentInfo {
    HashMap requestParameters = new HashMap();
    HashMap sessionAttributes = new HashMap();
    String uri;
    String uriPrefix;

    public EnvironmentInfo(Environment environment) {
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Enumeration requestParameterNames = request.getParameterNames();
        while (requestParameterNames.hasMoreElements()) {
            String paramName = (String)requestParameterNames.nextElement();
            String rawValue = request.getParameter(paramName);
            String value = rawValue != null ? rawValue : "null";
            this.requestParameters.put(paramName, value);
        }
        Session session = request.getSession(false);
        if (session != null) {
            Enumeration sessionAttributeNames = session.getAttributeNames();
            while (sessionAttributeNames.hasMoreElements()) {
                String attrName = (String)sessionAttributeNames.nextElement();
                Object rawValue = session.getAttribute(attrName);
                String value = rawValue != null ? rawValue.toString() : "null";
                this.sessionAttributes.put(attrName, value);
            }
        }
        this.uri = environment.getURI();
        this.uriPrefix = environment.getURIPrefix();
    }

    public String getURI() {
        return this.uri;
    }

    public Map getRequestParameters() {
        return this.requestParameters;
    }

    public Map getSessionAttributes() {
        return this.sessionAttributes;
    }
}

