/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.http.AbstractXMLHandler;

public class XMLSnapshotsHandler
extends AbstractXMLHandler {
    public XMLSnapshotsHandler(DefaultInstrumentManager manager) {
        super("/snapshots.xml", manager);
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        String[] names = this.getParameters(parameters, "name");
        long[] baseTimes = this.getLongParameters(parameters, "base-time", 0L);
        boolean packed = this.getBooleanParameter(parameters, "packed", false);
        boolean compact = this.getBooleanParameter(parameters, "compact", false);
        if (baseTimes.length == 0 && names.length > 0) {
            baseTimes = new long[names.length];
        } else if (names.length != baseTimes.length) {
            throw new FileNotFoundException("The number of base-time values not equal to the number of names.");
        }
        out.println("<?xml version='1.0' encoding='UTF-8'?>");
        if (names.length > 0) {
            this.outputLine(out, "", packed, "<samples>");
            for (int i = 0; i < names.length; ++i) {
                try {
                    InstrumentSampleDescriptor desc = this.getInstrumentManager().locateInstrumentSampleDescriptor(names[i]);
                    this.outputSampleHistory(out, desc, "", baseTimes[i], packed, compact);
                    continue;
                }
                catch (NoSuchInstrumentSampleException e) {
                    this.outputLine(out, "  ", packed, "<sample name=\"" + names[i] + "\" expired=\"true\"/>");
                }
            }
            this.outputLine(out, "", packed, "</samples>");
        } else {
            this.outputLine(out, "", packed, "<samples/>");
        }
    }
}

