/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplets.basket;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.portal.LinkService;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplets.basket.Basket;
import org.apache.cocoon.portal.coplets.basket.BasketEvent;
import org.apache.cocoon.portal.coplets.basket.BasketManager;
import org.apache.cocoon.portal.coplets.basket.CleanBasketEvent;
import org.apache.cocoon.portal.coplets.basket.ContentItem;
import org.apache.cocoon.portal.coplets.basket.RefreshBasketEvent;
import org.apache.cocoon.portal.coplets.basket.RemoveItemEvent;
import org.apache.cocoon.portal.coplets.basket.SaveBasketEvent;
import org.apache.cocoon.portal.coplets.basket.ShowBasketEvent;
import org.apache.cocoon.portal.coplets.basket.ShowItemEvent;
import org.apache.cocoon.portal.profile.ProfileManager;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BasketGenerator
extends ServiceableGenerator {
    protected String showCopletId;
    protected String showLayoutId;
    protected boolean adminMode;
    protected BasketManager basketManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.basketManager = (BasketManager)this.manager.lookup(BasketManager.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.basketManager);
            this.basketManager = null;
        }
        super.dispose();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.showCopletId = par.getParameter("show-coplet", null);
        this.showLayoutId = par.getParameter("show-layout", null);
        this.adminMode = par.getParameterAsBoolean("admin-mode", false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        this.xmlConsumer.startDocument();
        if (this.adminMode) {
            this.generateAdminMode();
        } else {
            Basket basket = this.basketManager.getBasket();
            PortalService service = null;
            try {
                try {
                    service = (PortalService)this.manager.lookup(PortalService.ROLE);
                    LinkService linkService = service.getComponentManager().getLinkService();
                    XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"basket-content");
                    XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"item-count");
                    XMLUtils.data((ContentHandler)this.xmlConsumer, (String)String.valueOf(basket.size()));
                    XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"item-count");
                    XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"persist-url");
                    SaveBasketEvent saveEvent = new SaveBasketEvent();
                    XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(saveEvent));
                    XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"persist-url");
                    if (basket.size() > 0) {
                        ProfileManager profileManager = service.getComponentManager().getProfileManager();
                        XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"items");
                        int i = 0;
                        while (true) {
                            if (i >= basket.size()) {
                                XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"items");
                                break;
                            }
                            Object item = basket.getItem(i);
                            XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"item");
                            XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"id");
                            XMLUtils.data((ContentHandler)this.xmlConsumer, (String)item.toString());
                            XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"id");
                            if (item instanceof ContentItem) {
                                ContentItem ci = (ContentItem)item;
                                ShowItemEvent e = new ShowItemEvent(item, profileManager.getPortalLayout(null, this.showLayoutId), this.showCopletId);
                                XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"show-url");
                                XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(e));
                                XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"show-url");
                                if (ci.size() != -1) {
                                    XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"size");
                                    XMLUtils.data((ContentHandler)this.xmlConsumer, (String)String.valueOf(ci.size()));
                                    XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"size");
                                }
                            }
                            RemoveItemEvent removeEvent = new RemoveItemEvent(item);
                            XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"remove-url");
                            XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(removeEvent));
                            XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"remove-url");
                            XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"item");
                            ++i;
                        }
                    }
                    XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"basket-content");
                }
                catch (ServiceException se) {
                    throw new SAXException("Unable to lookup portal service.", (Exception)((Object)se));
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.manager.release((Object)service);
                throw throwable;
            }
            this.manager.release((Object)service);
        }
        this.xmlConsumer.endDocument();
    }

    protected void generateAdminMode() throws SAXException {
        List baskets = this.basketManager.getBaskets();
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                LinkService linkService = service.getComponentManager().getLinkService();
                XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"basket-admin");
                if (baskets.size() > 0) {
                    XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"baskets");
                    int i = 0;
                    while (i < baskets.size()) {
                        BasketManager.BasketDescription item = (BasketManager.BasketDescription)baskets.get(i);
                        XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"basket");
                        XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"id");
                        XMLUtils.data((ContentHandler)this.xmlConsumer, (String)item.id);
                        XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"id");
                        XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"size");
                        XMLUtils.data((ContentHandler)this.xmlConsumer, (String)String.valueOf(item.size));
                        XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"size");
                        BasketEvent event = new CleanBasketEvent(item.id);
                        XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"remove-url");
                        XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(event));
                        XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"remove-url");
                        event = new ShowBasketEvent(item.id);
                        XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"show-url");
                        XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(event));
                        XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"show-url");
                        XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"basket");
                        ++i;
                    }
                    XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"baskets");
                }
                BasketEvent e = new RefreshBasketEvent();
                XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"refresh-url");
                XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(e));
                XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"refresh-url");
                e = new CleanBasketEvent();
                XMLUtils.startElement((ContentHandler)this.xmlConsumer, (String)"clean-url");
                XMLUtils.data((ContentHandler)this.xmlConsumer, (String)linkService.getLinkURI(e));
                XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"clean-url");
                XMLUtils.endElement((ContentHandler)this.xmlConsumer, (String)"basket-admin");
            }
            catch (ServiceException se) {
                throw new SAXException("Unable to lookup portal service.", (Exception)((Object)se));
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)service);
    }
}

