/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import java.util.Locale;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.ComposedJXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;

public class ValueJXPathBinding
extends JXPathBindingBase {
    private final String xpath;
    private final String fieldId;
    private final JXPathBindingBase updateBinding;
    private final Convertor convertor;
    private final Locale convertorLocale;

    public ValueJXPathBinding(JXPathBindingBuilderBase.CommonAttributes commonAtts, String widgetId, String xpath, JXPathBindingBase[] updateBindings, Convertor convertor, Locale convertorLocale) {
        super(commonAtts);
        this.fieldId = widgetId;
        this.xpath = xpath;
        this.updateBinding = new ComposedJXPathBindingBase(JXPathBindingBuilderBase.CommonAttributes.DEFAULT, updateBindings);
        this.convertor = convertor;
        this.convertorLocale = convertorLocale;
    }

    public void doLoad(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Widget widget = this.selectWidget(frmModel, this.fieldId);
        if (widget == null) {
            throw new BindingException("The widget with the ID [" + this.fieldId + "] referenced in the binding does not exist in the form definition.");
        }
        Object value = jxpc.getValue(this.xpath);
        if (value != null && this.convertor != null) {
            if (value instanceof String) {
                ConversionResult conversionResult = this.convertor.convertFromString((String)value, this.convertorLocale, null);
                value = conversionResult.isSuccessful() ? conversionResult.getResult() : null;
            } else {
                this.getLogger().warn("Convertor ignored on backend-value which isn't of type String.");
            }
        }
        widget.setValue(value);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Done loading " + this.toString() + " -- value= " + value);
        }
    }

    public void doSave(Widget frmModel, JXPathContext jxpc) throws BindingException {
        Widget widget = this.selectWidget(frmModel, this.fieldId);
        Object value = widget.getValue();
        if (value != null && this.convertor != null) {
            value = this.convertor.convertToString(value, this.convertorLocale, null);
        }
        Object oldValue = jxpc.getValue(this.xpath);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("value= " + value + "-- oldvalue=" + oldValue);
        }
        boolean update = false;
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            JXPathContext subContext;
            block7: {
                jxpc.createPathAndSetValue(this.xpath, value);
                subContext = null;
                try {
                    subContext = jxpc.getRelativeContext(jxpc.getPointer(this.xpath));
                }
                catch (JXPathException e) {
                    if (!this.getLogger().isDebugEnabled()) break block7;
                    this.getLogger().debug("(Ignorable) problem binding field " + widget.getRequestParameterName(), (Throwable)e);
                }
            }
            if (subContext != null) {
                this.updateBinding.saveFormToModel(frmModel, subContext);
            }
            update = true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("done saving " + this.toString() + " -- value= " + value + " -- on-update == " + update);
        }
    }

    public String toString() {
        return "ValueJXPathBinding [widget=" + this.fieldId + ", xpath=" + this.xpath + "]";
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.updateBinding.enableLogging(logger);
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getXPath() {
        return this.xpath;
    }

    public Convertor getConvertor() {
        return this.convertor;
    }

    public Locale getConvertorLocale() {
        return this.convertorLocale;
    }
}

