/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.ConvertorBuilder;
import org.apache.cocoon.forms.datatype.convertor.FormattingDateConvertor;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.w3c.dom.Element;

public class FormattingDateConvertorBuilder
implements ConvertorBuilder {
    public Convertor build(Element configElement) throws Exception {
        Element patternsEl;
        String variant;
        FormattingDateConvertor convertor = new FormattingDateConvertor();
        if (configElement == null) {
            return convertor;
        }
        String style = configElement.getAttribute("style");
        if (!style.equals("")) {
            if (style.equals("short")) {
                convertor.setStyle(3);
            } else if (style.equals("medium")) {
                convertor.setStyle(2);
            } else if (style.equals("long")) {
                convertor.setStyle(1);
            } else if (style.equals("full")) {
                convertor.setStyle(0);
            } else {
                throw new Exception("Invalid value \"" + style + "\" for style attribute at " + DomHelper.getLocation(configElement));
            }
        }
        if (!(variant = configElement.getAttribute("variant")).equals("")) {
            if (variant.equals("date")) {
                convertor.setVariant(1);
            } else if (variant.equals("time")) {
                convertor.setVariant(2);
            } else if (variant.equals("datetime")) {
                convertor.setVariant(3);
            } else {
                throw new Exception("Invalid value \"" + variant + "\" for variant attribute at " + DomHelper.getLocation(configElement));
            }
        }
        if ((patternsEl = DomHelper.getChildElement(configElement, "http://apache.org/cocoon/forms/1.0#definition", "patterns", false)) != null) {
            Element[] patternEl = DomHelper.getChildElements(patternsEl, "http://apache.org/cocoon/forms/1.0#definition", "pattern");
            int i = 0;
            while (i < patternEl.length) {
                String locale = patternEl[i].getAttribute("locale");
                String pattern = DomHelper.getElementText(patternEl[i]);
                if (pattern.equals("")) {
                    throw new Exception("pattern element does not contain any content at " + DomHelper.getLocation(patternEl[i]));
                }
                if (locale.equals("")) {
                    convertor.setNonLocalizedPattern(pattern);
                } else {
                    Locale loc = I18nUtils.parseLocale((String)locale);
                    convertor.addFormattingPattern(loc, pattern);
                }
                ++i;
            }
        }
        return convertor;
    }
}

