/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cocoon.forms.formmodel.ClassDefinition;
import org.apache.cocoon.forms.formmodel.ContainerDefinition;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.DuplicateIdException;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.NewDefinition;
import org.apache.cocoon.forms.formmodel.UnionDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class WidgetDefinitionList {
    private List widgetDefinitions = new ArrayList();
    private Map widgetDefinitionsById = new HashMap();
    private WidgetDefinition definition;
    private boolean resolving;
    private ListIterator definitionsIt = this.widgetDefinitions.listIterator();

    public WidgetDefinitionList(WidgetDefinition definition) {
        this.definition = definition;
        this.resolving = false;
    }

    public void addWidgetDefinition(WidgetDefinition widgetDefinition) throws DuplicateIdException {
        String id = widgetDefinition.getId();
        if (!(widgetDefinition instanceof NewDefinition)) {
            if (this.widgetDefinitionsById.containsKey(id)) {
                String duplicateLocation = widgetDefinition.getLocation();
                String containerLocation = this.definition.getLocation();
                String firstLocation = this.getWidgetDefinition(id).getLocation();
                throw new DuplicateIdException("Duplicate widget id \"" + id + "\" detected at " + duplicateLocation + ".\n" + "Container widget \"" + this.definition.getId() + "\" at " + containerLocation + "\n" + "already contains a widget with id \"" + id + "\" at " + firstLocation + ".");
            }
            this.widgetDefinitionsById.put(widgetDefinition.getId(), widgetDefinition);
        }
        this.definitionsIt.add(widgetDefinition);
    }

    public List getWidgetDefinitions() {
        return this.widgetDefinitions;
    }

    public boolean hasWidget(String id) {
        return this.widgetDefinitionsById.containsKey(id);
    }

    public WidgetDefinition getWidgetDefinition(String id) {
        return (WidgetDefinition)this.widgetDefinitionsById.get(id);
    }

    public boolean isResolving() {
        return this.resolving;
    }

    public void resolve(List parents, WidgetDefinition parent) throws Exception {
        if (!this.resolving) {
            this.resolving = true;
            this.definitionsIt = this.widgetDefinitions.listIterator();
            parents.add(this.definition);
            while (this.definitionsIt.hasNext()) {
                WidgetDefinition widgetDefinition = (WidgetDefinition)this.definitionsIt.next();
                if (widgetDefinition instanceof ClassDefinition) continue;
                if (widgetDefinition instanceof NewDefinition) {
                    this.definitionsIt.remove();
                    ((NewDefinition)widgetDefinition).resolve(parents, this.definition);
                    continue;
                }
                if (!(widgetDefinition instanceof ContainerDefinition)) continue;
                ((ContainerDefinition)widgetDefinition).resolve(parents, this.definition);
            }
            parents.remove(parents.size() - 1);
            this.resolving = false;
        } else if (this.resolving) {
            ListIterator parentsIt = parents.listIterator(parents.size());
            while (parentsIt.hasPrevious()) {
                WidgetDefinition widgetDefinition = (WidgetDefinition)parentsIt.previous();
                if (widgetDefinition instanceof UnionDefinition) break;
                if (widgetDefinition != this.definition) continue;
                String location = this.definition.getLocation();
                if (parent instanceof FormDefinition) {
                    throw new Exception("Container: Non-terminating recursion detected in form definition (" + location + ")");
                }
                throw new Exception("Container: Non-terminating recursion detected in widget definition: " + parent.getId() + " (" + location + ")");
            }
        }
    }

    public void createWidget(Widget parent, String id) {
        WidgetDefinition widgetDefinition = (WidgetDefinition)this.widgetDefinitionsById.get(id);
        if (widgetDefinition == null) {
            throw new RuntimeException(this.definition.getId() + ": WidgetDefinition \"" + id + "\" does not exist (" + this.definition.getLocation() + ")");
        }
        Widget widget = widgetDefinition.createInstance();
        if (widget != null) {
            ((ContainerWidget)parent).addChild(widget);
        }
    }

    public void createWidgets(Widget parent) {
        Iterator definitionsIt = this.widgetDefinitions.iterator();
        while (definitionsIt.hasNext()) {
            WidgetDefinition widgetDefinition = (WidgetDefinition)definitionsIt.next();
            Widget widget = widgetDefinition.createInstance();
            if (widget == null) continue;
            ((ContainerWidget)parent).addChild(widget);
        }
    }
}

