/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.SAXiTextHandler;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.SAXException;

public final class iTextSerializer
extends AbstractSerializer
implements Configurable,
CacheableProcessingComponent {
    private static final boolean LANDSCAPE = true;
    private static final boolean PORTRAIT = false;
    private String mimetype = "application/pdf";
    private boolean setContentLength = true;
    private Rectangle pageSize;
    private boolean pageOrientation;
    private Document document = null;

    private Rectangle getPageSize(String s) throws ConfigurationException {
        if ("letter".equalsIgnoreCase(s)) {
            return PageSize.LETTER;
        }
        if ("a4".equalsIgnoreCase(s)) {
            return PageSize.A4;
        }
        if ("a5".equalsIgnoreCase(s)) {
            return PageSize.A5;
        }
        throw new ConfigurationException("page size [" + String.valueOf(s) + "] is not yet recognized");
    }

    private boolean getOrientation(String o) throws ConfigurationException {
        if ("portrait".equalsIgnoreCase(o)) {
            return false;
        }
        if ("landscape".equalsIgnoreCase(o)) {
            return true;
        }
        throw new ConfigurationException("orientation must be either portrait or landscape but is [" + String.valueOf(o) + "]");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.setContentLength = conf.getChild("set-content-length").getValueAsBoolean(true);
        this.mimetype = conf.getAttribute("mime-type");
        this.pageSize = this.getPageSize(conf.getAttribute("page-size", "A4"));
        this.pageOrientation = this.getOrientation(conf.getAttribute("page-orientation", "portrait"));
        if (this.pageOrientation) {
            this.pageSize = this.pageSize.rotate();
        }
        this.getLogger().debug("iTextSerializer mime-type:" + this.mimetype);
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public void startDocument() throws SAXException {
        this.getLogger().debug("starting PDF document");
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.getLogger().debug("finished PDF document");
    }

    public void setOutputStream(OutputStream out) {
        this.document = new Document(this.pageSize);
        try {
            PdfWriter.getInstance((Document)this.document, (OutputStream)out);
        }
        catch (Exception e) {
            this.getLogger().error("cannot create pdf writer instance", (Throwable)e);
        }
        SAXiTextHandler handler = new SAXiTextHandler((DocListener)this.document);
        handler.setControlOpenClose(true);
        this.contentHandler = handler;
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public boolean shouldSetContentLength() {
        return this.setContentLength;
    }
}

