/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.oai;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.SAXException;

/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: May 8, 2003
 * Time: 3:05:07 PM
 * To change this template use Options | File Templates.
 */

/**Basic interface for an OAI metadata format
 *
 */
public interface OAIMetadataFormat extends OAIObject, Configurable {

    /**Gets the name of the oai format used in the ListMetadataFormats response*/
    String getName();

    /**Sets the name of the oai format used in the ListMetadataFormats response*/
    void setName(String formatName);

    /**Gets the name of the oai format metadataPrefix*/
    String getPrefix();

    /**Sets the name of the oai format metadataPrefix*/
    void setPrefix(String prefix);

    /**Gets the url of the schemaLocation for the metadata format*/
    String getSchemaUrl();

    /**Sets the url of the schemaLocation for the metadata format*/
    void setSchemaUrl(String schemaUrl);

    /**Gets the namespace for the metadata format*/
    String getNamespace();

    /**Sets the namespace for the metadata format*/
    void setNamespace(String namespace);

    /**Sends the startElement event of the root element (ie. oai:dc or 'prefix') of the metadata format */
    void startMetadataFormatRootElement() throws SAXException;

    /**Sends the endElement event of the root element (ie. oai:dc or 'prefix') of the metadata format */
    void endMetadataFormatRootElement() throws SAXException;

    /**Gets the parameters object containing mappings of elements to metadata format elements*/
    Parameters getMappings();

    /**Sets the parameters object containing mappings of elements to metadata format elements*/
    void setMappings(Parameters mappings);

    /**Sends an element to the consumer doing any necessary transformations using mappings*/
    void sendElement(String origName, String value) throws SAXException;


}
