/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.document;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;

import javax.xml.transform.sax.TransformerHandler;

import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;

import fr.gouv.culture.sdx.exception.SDXException;

/**
 * An indexable document is a document that can be indexed with SDX.
 *
 * <p>
 * Such a document must be able to receive SAX events that will build
 * the fields to index, and return thoses fields to the caller.
 */
public interface IndexableDocument extends fr.gouv.culture.sdx.document.Document, XMLConsumer {

    /** Returns an enumeration of Property, one for each field defined. */
    public Enumeration getFieldValues();

    /** Starts the indexing process. */
    public void startIndexing(SAXParser parser, XMLConsumer consumer) throws SDXException;

    /**Returns an enumeration of the documentsN attached to this document*/
    public Enumeration getAttachedDocuments();

    /**Returns an enumeration of the sub(Indexable) documents attached to this document*/
    public Enumeration getSubDocuments();

    /**Allows a transformed document to be built from a byte array*/
    public void setTransformedDocument(byte[] content) throws SDXException;

    /**Allows a transformed document to be built from a file*/
    public void setTransformedDocument(File file) throws SDXException;

    /**Returns the transformed document*/
    public IndexableDocument getTransformedDocument();

    public AbstractIndexableDocument.StoreHandler getStoreHandler();

    void setMessageHandler(ContentHandler handler);

    void setBoost(float boost);

    float getBoost();

    /**Reinits the Vector of attached documents*/
    void resetAttachedDocuments();

    /**Sets the XMLFieldList of the DocumentBase where the document is stored.
     * give each name of the fields with a XML type.
     */
    public void setXMLFieldList(HashMap fieldList);

    /**Sets the XMLTransformer used to parse the xml fields
     */
    public void setXMLTransformerHandler(TransformerHandler xmlFieldTransformer);

    /**Some additional system fields adding to the Lucene document*/
    public void addAdditionalSystemFields(org.apache.lucene.document.Document doc);


}
