/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.utils.database.Database;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.logger.LogEnabled;

public interface IDGenerator extends LogEnabled, Configurable {

    interface ConfigurationNode {

        /** The element used to define an id generator. */
        String ID_GENERATOR = "idGenerator";
        /** The attribute used to define a class for an id generator. */
        String CLASS = "class";

        interface Value {
            /** Default value for this attribute. */
            String DEFAULT_ID_GENERATOR_CLASS = "fr.gouv.culture.sdx.documentbase.DefaultIDGenerator";
        }
    }

    String PACKAGE_QUALNAME = "fr.gouv.culture.sdx.documentbase.";
    String CLASS_NAME_SUFFIX = "IDGenerator";


    /**Generates an id appending the given strings
     *
     * @param prefix    The prefix for the generated id
     * @param suffix    The suffix for the generated id
     * */
    String generate(String prefix, String suffix);

    /**Generates an id using configured prefix and suffix*/
    String generate();

    /**Sets the index for verification of a generated id's uniqueness
     *
     * @deprecated  This was dependency on our Lucene packages
     */
    void setIndex(Index index);

    /**Sets the database for verification of a generated id's uniqueness*/
    void setDatabase(Database database);

    /**Determines where an id is unique within an index*/
    boolean isIdUnique(String id);

    /**Set's the field name for the id field in the index for id verification needs
     *
     * @deprecated No longer necesssary as we now use Database for id verification
     */
    void setIdFieldName(String fieldName);

    String getSuffix();

    void setSuffix(String idSuffix);

    String getPrefix();

    void setPrefix(String idPrefix);

}
