/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.xml;

import java.util.Stack;

public class SimpleXPathString {
    protected Stack uris = new Stack();
    protected String localXPath = "";
    protected String qualifiedXPath = "";

    public String getUri() {
        return (String) uris.peek();
    }

    public void removeUri(String uri) {
        uris.remove(uri);
    }

    public void setUri(String uri) {
        uris.push(uri);
    }

    public String concatLocalXPath(String localName) {
        localXPath += "/" + localName;
        return localXPath;
    }

    public String concatQualifiedXPath(String qualifiedName) {
        qualifiedXPath += "/" + qualifiedName;
        return qualifiedXPath;
    }

    public String trimLocalXPath(String localName) {
    	if(!localName.equals(""))
    		localXPath = localXPath.substring(0, localXPath.lastIndexOf("/" + localName));
        return localXPath;
    }

    public String trimQualifiedXPath(String localName) {
    	if(!localName.equals(""))
    		qualifiedXPath = qualifiedXPath.substring(0, qualifiedXPath.lastIndexOf("/" + localName));
        return qualifiedXPath;
    }

    public String getLocalXPath() {
        return localXPath;
    }

    public String getQualifiedXPath() {
        return qualifiedXPath;
    }
    /*
    *What about root matches like //* ?
    *What about matches like /* ?
    */


}
