/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.xml.SimpleXPathString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractNodeBasedTransformation
extends AbstractTransformation {
    protected HashMap _attributesToTrack = new HashMap();
    protected HashMap _wildcardNodesToTrack = new HashMap();
    protected String c_uri = "";
    protected String c_loc = "";
    protected String c_raw = "";
    protected Stack c_attributes = new Stack();
    protected SimpleXPathString _xpathString = new SimpleXPathString();

    protected void resetFields() {
        this.c_uri = "";
        this.c_loc = "";
        this.c_raw = "";
        this.c_attributes = new Stack();
        this._xpathString = new SimpleXPathString();
    }

    protected Attributes peekCurrentAttributes() {
        Attributes l_atts = null;
        if (this.c_attributes.size() > 0) {
            l_atts = (Attributes)this.c_attributes.peek();
        }
        return l_atts;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.setInternalParameters(this.transParameters);
    }

    protected void setCurrentElementProperties(String uri, String loc, String raw, Attributes atts) {
        this.c_uri = uri;
        this.c_loc = loc;
        this.c_raw = raw;
        if (atts == null) {
            atts = new AttributesImpl();
        }
        this.c_attributes.push(atts);
        if (Utilities.checkString(this.c_uri)) {
            this._xpathString.setUri(this.c_uri);
        }
        if (Utilities.checkString(this.c_loc)) {
            this._xpathString.concatLocalXPath(this.c_loc);
        }
        if (Utilities.checkString(this.c_raw)) {
            this._xpathString.concatQualifiedXPath(this.c_raw);
        }
    }

    protected void resetCurrentElementProperties(String uri, String loc, String raw) {
        this._xpathString.removeUri(uri);
        this._xpathString.trimLocalXPath(loc);
        this._xpathString.trimQualifiedXPath(raw);
        this.c_uri = "";
        this.c_loc = "";
        this.c_raw = "";
        if (this.c_attributes.size() > 0) {
            this.c_attributes.pop();
        }
    }

    protected void setInternalParameters(Parameters params) {
        this.transParameters = params;
        this.setNodesToTrack(params);
    }

    protected void setNodesToTrack(Parameters params) {
        String[] paramNames = params.getNames();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            if (paramName.indexOf("/@") > -1 || paramName.indexOf("@") == 0 && paramName.indexOf("/*/") == -1 && !paramName.startsWith("//")) {
                this._attributesToTrack.put(paramName, params.getParameter(paramName, ""));
                continue;
            }
            if (!paramName.startsWith("//") && paramName.indexOf("/*/") <= 0) continue;
            this._wildcardNodesToTrack.put(paramName, params.getParameter(paramName, ""));
        }
    }

    protected boolean nodeIsParameter(String uri, String loc, String raw, Attributes atts) {
        boolean l_nodeIsParam = false;
        if (Utilities.checkString(this.elementIsParameter(uri, loc, raw, atts))) {
            l_nodeIsParam = true;
        }
        if (!l_nodeIsParam && Utilities.checkString(this.attributeIsParameter(uri, loc, raw, atts))) {
            l_nodeIsParam = true;
        }
        return l_nodeIsParam;
    }

    protected String elementIsParameter(String uri, String loc, String raw, Attributes atts) {
        String l_elementName = null;
        if (this.transParameters != null && (loc != null || uri != null)) {
            String l_mappedUri = "";
            String l_prefix = "";
            int l_colonIdx = raw.indexOf(":");
            if (l_colonIdx < 0) {
                l_colonIdx = raw.length();
            }
            l_prefix = raw.substring(0, l_colonIdx);
            String l_elemNameFromWildcard = this.matchesWildcardElement(loc, raw);
            if (Utilities.checkString(l_elemNameFromWildcard) && l_elemNameFromWildcard.indexOf("@") == -1) {
                l_elementName = l_elemNameFromWildcard;
                if (Utilities.checkString(l_mappedUri = this.transParameters.getParameter(l_elemNameFromWildcard, l_mappedUri)) && !l_mappedUri.equals(uri)) {
                    l_elementName = null;
                }
            } else if (this.transParameters.isParameter(loc)) {
                l_elementName = loc;
                if (Utilities.checkString(l_mappedUri = this.transParameters.getParameter(loc, l_mappedUri)) && !l_mappedUri.equals(uri)) {
                    l_elementName = null;
                }
            } else if (this.transParameters.isParameter(raw)) {
                l_elementName = raw;
                if (Utilities.checkString(l_mappedUri = this.transParameters.getParameter(raw, l_mappedUri)) && !l_mappedUri.equals(uri)) {
                    l_elementName = null;
                }
            } else if (this.transParameters.isParameter(this._xpathString.getLocalXPath())) {
                l_elementName = this._xpathString.getLocalXPath();
                l_mappedUri = this.transParameters.getParameter(this._xpathString.getLocalXPath(), l_mappedUri);
                if (Utilities.checkString(l_mappedUri) && !l_mappedUri.equals(uri)) {
                    l_elementName = null;
                }
            } else if (this.transParameters.isParameter(this._xpathString.getQualifiedXPath())) {
                l_elementName = this._xpathString.getQualifiedXPath();
                l_mappedUri = this.transParameters.getParameter(this._xpathString.getQualifiedXPath(), l_mappedUri);
                if (Utilities.checkString(l_mappedUri) && !l_mappedUri.equals(uri)) {
                    l_elementName = null;
                }
            } else if (this.transParameters.isParameter(l_prefix)) {
                l_elementName = "ns-prefix : " + l_prefix;
                l_mappedUri = this.transParameters.getParameter(l_prefix, "");
                if (Utilities.checkString(l_mappedUri) && !l_mappedUri.equals(uri)) {
                    l_elementName = null;
                }
            } else if (this.transParameters.isParameter(uri)) {
                l_elementName = "ns-uri : " + uri;
                String l_mappedPrefix = this.transParameters.getParameter(uri, "");
                if (Utilities.checkString(l_mappedPrefix) && !l_mappedPrefix.equals(l_prefix)) {
                    l_elementName = null;
                }
            }
        }
        return l_elementName;
    }

    protected String attributeIsParameter(String uri, String loc, String raw, Attributes atts) {
        if (this._attributesToTrack == null && this._wildcardNodesToTrack == null) {
            return null;
        }
        if (this._attributesToTrack.size() == 0 && this._wildcardNodesToTrack.size() == 0) {
            return null;
        }
        String l_attributName = null;
        String l_attNameFromWildcard = this.matchesWildcardAttribute(loc, raw);
        if (Utilities.checkString(l_attNameFromWildcard)) {
            String l_mappedAttValue = (String)this._wildcardNodesToTrack.get(l_attNameFromWildcard);
            String l_attName = l_attNameFromWildcard.substring(l_attNameFromWildcard.indexOf("@") + 1, l_attNameFromWildcard.length());
            String l_attValue = atts.getValue(l_attName);
            if (l_attValue != null) {
                l_attributName = l_attName;
                if (Utilities.checkString(l_mappedAttValue) && !l_mappedAttValue.equals(l_attValue)) {
                    l_attributName = null;
                }
            }
        }
        if (l_attributName != null) {
            return l_attributName;
        }
        Iterator l_attributesToEvaluate = this._attributesToTrack.keySet().iterator();
        while (l_attributesToEvaluate.hasNext()) {
            String l_attributeKey = (String)l_attributesToEvaluate.next();
            String l_mappedAttValue = (String)this._attributesToTrack.get(l_attributeKey);
            String l_attName = l_attributeKey.substring(l_attributeKey.indexOf("@") + 1, l_attributeKey.length());
            String l_attValue = atts.getValue(l_attName);
            if (this._xpathString.getLocalXPath().equals("/") && l_attributeKey.startsWith("/@")) {
                if (l_attValue != null) {
                    l_attributName = l_attName;
                    if (Utilities.checkString(l_mappedAttValue) && !l_mappedAttValue.equals(l_attValue)) {
                        l_attributName = null;
                    }
                }
            } else if ((l_attributeKey.startsWith("@") || l_attributeKey.startsWith("//@") || l_attributeKey.startsWith(this._xpathString.getLocalXPath()) || l_attributeKey.startsWith(this._xpathString.getQualifiedXPath())) && l_attValue != null) {
                l_attributName = l_attName;
                if (Utilities.checkString(l_mappedAttValue) && !l_mappedAttValue.equals(l_attValue)) {
                    l_attributName = null;
                }
            }
            if (l_attributName == null) continue;
            return l_attributName;
        }
        return l_attributName;
    }

    protected String matchesWildcardElement(String loc, String raw) {
        String l_elementName = null;
        Iterator l_wildcardNamesToEvaluate = this._wildcardNodesToTrack.keySet().iterator();
        while (l_wildcardNamesToEvaluate.hasNext()) {
            String l_wildcardNodeExpr = (String)l_wildcardNamesToEvaluate.next();
            if (l_wildcardNodeExpr.indexOf("@") == -1) {
                l_elementName = this.matchesWildcardName(loc, raw, l_wildcardNodeExpr);
            }
            if (l_elementName == null) continue;
            return l_elementName;
        }
        return l_elementName;
    }

    protected String matchesWildcardAttribute(String loc, String raw) {
        String l_attributeName = null;
        Iterator l_wildcardNamesToEvaluate = this._wildcardNodesToTrack.keySet().iterator();
        while (l_wildcardNamesToEvaluate.hasNext()) {
            String l_wildcardNodeExpr = (String)l_wildcardNamesToEvaluate.next();
            if (l_wildcardNodeExpr.indexOf("@") > -1) {
                l_attributeName = this.matchesWildcardName(loc, raw, l_wildcardNodeExpr);
            }
            if (l_attributeName == null) continue;
            return l_attributeName;
        }
        return l_attributeName;
    }

    protected String matchesWildcardName(String loc, String raw, String wildcardExpr) {
        String l_nodeName = null;
        String l_wildcardNodeExpr = wildcardExpr;
        String l_wildcardAttrStr = "//@";
        String l_wildcardLocalStr = "//" + loc;
        String l_wildcardQualStr = "//" + raw;
        String l_localXpathStr = this._xpathString.getLocalXPath();
        String l_QualXpathStr = this._xpathString.getQualifiedXPath();
        if (l_wildcardNodeExpr.startsWith(l_wildcardAttrStr)) {
            return l_wildcardNodeExpr;
        }
        if (l_wildcardNodeExpr.equals(l_wildcardLocalStr)) {
            return l_wildcardNodeExpr;
        }
        if (l_wildcardNodeExpr.equals(l_wildcardQualStr)) {
            return l_wildcardNodeExpr;
        }
        if (l_wildcardNodeExpr.indexOf("/*/") > 0) {
            if (this.wildCardExprMatchesElementXpathString(l_wildcardNodeExpr, l_localXpathStr)) {
                return l_wildcardNodeExpr;
            }
            if (this.wildCardExprMatchesElementXpathString(l_wildcardNodeExpr, l_QualXpathStr)) {
                return l_wildcardNodeExpr;
            }
        }
        return l_nodeName;
    }

    protected boolean wildCardExprMatchesElementXpathString(String wildcardExpr, String xpathStr) {
        String l_wildcardExpr = wildcardExpr;
        if (l_wildcardExpr.startsWith("//")) {
            l_wildcardExpr = l_wildcardExpr.substring(1);
        }
        String l_wildcardExprNoAttr = null;
        int attIdx = l_wildcardExpr.indexOf("@");
        if (attIdx > -1) {
            l_wildcardExprNoAttr = l_wildcardExpr.substring(0, attIdx);
        }
        if (wildcardExpr.startsWith("//") && xpathStr.indexOf(l_wildcardExprNoAttr) > -1) {
            return true;
        }
        String l_exprBeforeAsterix = l_wildcardExprNoAttr.substring(0, l_wildcardExprNoAttr.indexOf("/*/"));
        String l_exprAfterAsterix = l_wildcardExprNoAttr.substring(l_wildcardExprNoAttr.indexOf("/*/") + 3, l_wildcardExpr.length());
        return xpathStr.indexOf(l_exprBeforeAsterix) == 0 && xpathStr.indexOf(l_exprAfterAsterix) == (l_exprBeforeAsterix + "/*/").length();
    }

    public void recycle() {
        super.recycle();
        this.resetFields();
    }
}

