/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLConsumer;

public abstract class AbstractDatabaseBackedRepository
extends DatabaseBacked
implements Repository {
    protected boolean isDefault;
    private final String ATTRIBUTE_READ_ONLY = "read-only";

    protected void loadBaseConfiguration(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (!Utilities.checkString(super.getId())) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(super.getLog(), 18, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
    }

    public void releaseConnection(RepositoryConnection c) throws SDXException {
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void delete(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
    }

    public void add(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        this.checkConnection(c);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        encoding = this.checkEncoding(encoding);
        this.checkConnection(c);
        return null;
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkOutputStream(super.getLog(), os);
        this.checkConnection(c);
    }

    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(super.getLog(), doc);
        Utilities.checkXmlConsumer(super.getLog(), consumer);
        this.checkConnection(c);
    }

    public void setIsDefault(boolean b) {
        this.isDefault = b;
    }

    protected String checkEncoding(String encoding) throws SDXException {
        String defaultEncoding = "UTF-8";
        if (Utilities.checkString(encoding)) {
            try {
                defaultEncoding.getBytes(encoding);
                return encoding;
            }
            catch (UnsupportedEncodingException e) {
                LoggingUtils.logException(super.getLog(), e);
                try {
                    defaultEncoding.getBytes(defaultEncoding);
                    LoggingUtils.logInfo(super.getLog(), "using the default encoding: " + defaultEncoding);
                    return defaultEncoding;
                }
                catch (UnsupportedEncodingException e1) {
                    String[] args = new String[]{defaultEncoding, e1.getMessage()};
                    throw new SDXException(super.getLog(), 217, args, null);
                }
            }
        }
        return defaultEncoding;
    }

    public void checkConnection(RepositoryConnection c) throws SDXException {
        if (c == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 3005, args, null);
        }
    }

    public void optimize() throws SDXException {
        if (this._database != null) {
            this._database.optimize();
        }
    }

    public boolean exists(String id, RepositoryConnection conn) {
        return this._database.entityExists(id);
    }

    protected String getClassNameSuffix() {
        return "Repository";
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Is_default", String.valueOf(this.isDefault()));
        try {
            String read_only = this._configuration.getAttribute(this.ATTRIBUTE_READ_ONLY);
            if (read_only != null) {
                this._xmlizable_objects.put("Read_Only", read_only);
            } else {
                this._xmlizable_objects.put("Read_Only", "false");
            }
        }
        catch (ConfigurationException e) {
            this._xmlizable_objects.put("Read_Only", "false");
        }
        this._xmlizable_objects.put("Repository_Type", this.getClass().getName());
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        this._xmlizable_objects.put("Is_default", String.valueOf(this.isDefault()));
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            String repo_path = save_config.getUniqueIDString() + "_repo";
            if (save_config.getAttributeAsBoolean("all", false)) {
                save_config.savePathInConfig(repo_path);
                File repo_dir = new File(save_config.getStoreCompletePath() + File.separator + repo_path);
                if (!repo_dir.exists()) {
                    repo_dir.mkdir();
                }
                save_config.setAttribute("id", this.getId());
                SaveParameters data_save = new SaveParameters(Utilities.getElementName("Database"), save_config, repo_path);
                if (this._database != null) {
                    this._database.backup(data_save);
                }
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
    }
}

