/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractDataSourceComponentBackedRepository;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;

public class JDBCRepository
extends AbstractDataSourceComponentBackedRepository {
    public static final int NO_SPECIFIC_TYPE = -1;
    protected static final String FIELD_DATA = "data";
    private static final long RESULT_MAX_SIZE = 500L;
    protected final int PARAM_INDEX_FIELD_DATA_ORIGINAL = 2;

    public RepositoryConnection getConnection() throws SDXException {
        try {
            JDBCRepositoryConnection conn = new JDBCRepositoryConnection(this.getDataSourceComponent());
            conn.enableLogging(super.getLog());
            return conn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3007, args, e);
        }
        catch (ServiceException e) {
            String[] args = new String[]{e.getMessage()};
            SDXException sdxE = new SDXException(null, 3201, args, e);
            String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
            throw new SDXException(super.getLog(), 3007, args2, (Throwable)((Object)sdxE));
        }
    }

    public void releaseConnection(RepositoryConnection c) throws SDXException {
        if (c != null) {
            if (((JDBCRepositoryConnection)c).getConnection() != null) {
                ((JDBCRepositoryConnection)c).releaseSqlConnection();
            }
            this.releaseDataSourceComponent(((JDBCRepositoryConnection)c).getDataSource());
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.loadBaseConfiguration(configuration);
        this.tableName = Utilities.getStringFromContext("sdx.application.dirName", (Context)this.getContext()) + "_" + super.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        JDBCRepositoryConnection repoConn;
        block13: {
            Connection conn = null;
            ResultSet rs = null;
            repoConn = (JDBCRepositoryConnection)this.getConnection();
            try {
                try {
                    conn = repoConn.getConnection();
                    DatabaseMetaData dbmd = conn.getMetaData();
                    String tableName = this.getTableName();
                    StringTokenizer tnTokens = new StringTokenizer(tableName, "_", true);
                    String escapedTableName = "";
                    while (tnTokens.hasMoreTokens()) {
                        String nextToken = tnTokens.nextToken();
                        if (nextToken.equals("_") || nextToken.equals("%")) {
                            nextToken = dbmd.getSearchStringEscape() + nextToken;
                        }
                        escapedTableName = escapedTableName + nextToken;
                    }
                    if (Utilities.checkString(escapedTableName)) {
                        tableName = escapedTableName;
                    }
                    if (!((rs = dbmd.getTables(null, null, tableName, null)).next() || (rs = dbmd.getTables(null, null, tableName.toLowerCase(), null)).next() || (rs = dbmd.getTables(null, null, tableName.toUpperCase(), null)).next())) {
                        this.createTable(conn);
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(super.getLog(), 3008, args, e);
                }
                Object var10_11 = null;
                if (rs == null) break block13;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(super.getLog(), 3200, args, e);
                    }
                }
                repoConn.commit();
                this.releaseConnection(repoConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3200, args, e);
            }
            rs.close();
        }
        repoConn.commit();
        this.releaseConnection(repoConn);
    }

    public long size() throws SDXException {
        return this.size(-1);
    }

    private long size(final int type) throws SDXException {
        long l;
        JDBCRepositoryConnection repoConn = (JDBCRepositoryConnection)this.getConnection();
        Connection conn = null;
        try {
            conn = repoConn.getConnection();
            String queryString = "SELECT count(*) FROM ?";
            if (type != -1) {
                queryString = queryString + " WHERE data=?";
            }
            JDBC.Template template = new JDBC.Template(conn, queryString);
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                int l_value = 0;

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, JDBCRepository.this.getTableName());
                    ps.setInt(2, type);
                }

                public void collect(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        this.l_value = rs.getInt(1);
                    }
                }

                public int value() {
                    return this.l_value;
                }
            };
            template.execute(qe, 0);
            l = qe.value();
            Object var10_10 = null;
        }
        catch (SDXException e) {
            try {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3009, args, (Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.releaseConnection(repoConn);
                throw throwable;
            }
        }
        this.releaseConnection(repoConn);
        return l;
    }

    public void lists(ContentHandler hdl) throws SDXException {
    }

    public synchronized void add(Document doc, RepositoryConnection c) throws SDXException {
        super.add(doc, c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentAddQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            final String docId = doc.getId();
            final InputStream is = doc.openStream();
            final int length = is.available();
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, docId);
                    ps.setBinaryStream(2, is, length);
                }
            };
            template.execute(qe, 1);
        }
        catch (SDXException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3000, args, (Throwable)((Object)e));
        }
        catch (IOException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3000, args, e);
        }
    }

    public synchronized void empty() throws SDXException {
        Connection conn = null;
        JDBCRepositoryConnection repoConn = (JDBCRepositoryConnection)this.getConnection();
        try {
            try {
                conn = repoConn.getConnection();
                String queryString = this.getDeleteAllQuery();
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){};
                template.execute(qe, 1);
            }
            catch (SDXException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3003, args, (Throwable)((Object)e));
            }
            Object var7_8 = null;
            repoConn.commit();
            this.releaseConnection(repoConn);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            repoConn.commit();
            this.releaseConnection(repoConn);
            throw throwable;
        }
    }

    public synchronized void delete(Document doc, RepositoryConnection c) throws SDXException {
        super.delete(doc, c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentDeleteQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            final String docId = doc.getId();
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, docId);
                }
            };
            template.execute(qe, 1);
        }
        catch (SDXException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3004, args, (Throwable)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        super.toSAX(doc, consumer, c);
        SAXParser parser = null;
        ServiceManager l_manager = super.getServiceManager();
        try {
            try {
                doc.setContent(this.openStream(doc, null, c));
                parser = (SAXParser)l_manager.lookup(SAXParser.ROLE);
                doc.parse(parser, consumer);
            }
            catch (ServiceException e) {
                String[] args = new String[]{e.getMessage()};
                SDXException sdxE = new SDXException(null, 2001, args, e);
                String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
                throw new SDXException(super.getLog(), 3001, args2, (Throwable)((Object)sdxE));
            }
            Object var11_6 = null;
            if (parser == null) return;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            if (parser == null) throw throwable;
            l_manager.release(parser);
            throw throwable;
        }
        l_manager.release((Object)parser);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        super.openStream(doc, encoding, c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentGetQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            final String docId = doc.getId();
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                InputStream l_is = null;

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, docId);
                }

                public void collect(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        this.l_is = rs.getBinaryStream(JDBCRepository.FIELD_DATA);
                    }
                }

                public InputStream getInputStream() {
                    return this.l_is;
                }
            };
            template.execute(qe, 0);
            InputStream is = qe.getInputStream();
            if (is == null) {
                String[] args = new String[]{doc.getId(), this.getId()};
                throw new SDXException(super.getLog(), 3001, args, null);
            }
            return is;
        }
        catch (SDXException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, (Throwable)((Object)e));
        }
    }

    public void get(Document doc, final OutputStream os, RepositoryConnection c) throws SDXException {
        super.get(doc, os, c);
        Connection conn = ((JDBCRepositoryConnection)c).getConnection();
        String queryString = this.getDocumentGetQuery();
        try {
            JDBC.Template template = new JDBC.Template(conn, queryString);
            final String docId = doc.getId();
            JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                public void prepare(PreparedStatement ps) throws SQLException {
                    ps.setString(1, docId);
                }

                public void collect(ResultSet rs) throws SQLException, IOException {
                    if (rs.next()) {
                        IOUtils.copy((InputStream)rs.getBinaryStream(JDBCRepository.FIELD_DATA), (OutputStream)os);
                    }
                }
            };
            template.execute(qe, 0);
        }
        catch (SDXException e) {
            String[] args = new String[]{doc.getId(), this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3001, args, (Throwable)((Object)e));
        }
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + FIELD_DATA + " BINARY, PRIMARY KEY (" + "id" + "))";
    }

    protected String getDocumentAddQuery() {
        return "INSERT INTO " + this.getTableName() + " (" + "id" + "," + FIELD_DATA + ") VALUES (?, ?)";
    }

    protected String getDocumentDeleteQuery() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "id" + " = ?";
    }

    protected String getDeleteAllQuery() {
        return "DELETE FROM " + this.getTableName();
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM " + this.getTableName() + ";";
        return query;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        this._xmlizable_objects.put("Is_default", String.valueOf(this.isDefault()));
        try {
            this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
        this._xmlizable_objects.put("Repository_Type", this.getClass().getName());
        if (this.dsi != null) {
            this._xmlizable_objects.put("Data_Source_Identifier", this.dsi);
        } else {
            this._xmlizable_objects.put("Data_Source_Identifier", "none");
        }
        return true;
    }

    protected void initVolatileObjectsToSax() {
        this._xmlizable_objects.put("Is_default", String.valueOf(this.isDefault()));
        try {
            this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
    }

    public void backup(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            String repo_path = save_config.getUniqueIDString() + "_repo";
            if (save_config.getAttributeAsBoolean("all", false)) {
                save_config.savePathInConfig(repo_path);
                File repo_dir = new File(save_config.getStoreCompletePath() + File.separator + repo_path);
                if (!repo_dir.exists()) {
                    repo_dir.mkdir();
                }
                save_config.setAttribute("id", this.getId());
                try {
                    FileOutputStream fo = new FileOutputStream(save_config.getStoreCompletePath() + File.separator + repo_path + File.separator + "repo.zip");
                    this.backupRepositoryData(fo);
                }
                catch (IOException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.getLog(), 8204, args, e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void backupRepositoryData(FileOutputStream fo) throws SDXException {
        ZipOutputStream zos = new ZipOutputStream(fo);
        ZipOutputStream zos_temp = null;
        int count = 0;
        RepositoryConnection sqlrepoConn = this.getConnection();
        Connection conn = ((JDBCRepositoryConnection)sqlrepoConn).getConnection();
        try {
            try {
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery("SELECT COUNT(*) FROM " + this.getTableName());
                long num_entries = 0L;
                while (rs.next()) {
                    num_entries = rs.getLong(1);
                }
                long max_batch = num_entries / 500L;
                if (num_entries % 500L != 0L) {
                    ++max_batch;
                }
                for (long i = 0L; i < max_batch; ++i) {
                    if (i % 100L == 0L) {
                        if (i != 0L) {
                            zos_temp.finish();
                        }
                        zos.putNextEntry(new ZipEntry(String.valueOf(i / 100L) + ".zip"));
                        zos_temp = new ZipOutputStream(zos);
                        count = 0;
                    }
                    rs = st.executeQuery(this.getEntriesWithLimitQuery(i * 500L, 500L));
                    while (rs.next()) {
                        zos_temp.putNextEntry(new ZipEntry(String.valueOf(count++) + ".dat"));
                        zos_temp.write((rs.getString("id") + "\n").getBytes());
                        zos_temp.write(rs.getBytes(FIELD_DATA));
                    }
                }
                zos_temp.finish();
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, e);
            }
            catch (IOException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, e);
            }
            Object var16_16 = null;
            this.releaseConnection(sqlrepoConn);
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.releaseConnection(sqlrepoConn);
            try {
                zos.close();
                throw throwable;
            }
            catch (IOException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, ee);
            }
        }
        try {}
        catch (IOException ee) {
            String[] args = new String[]{this.getId(), ee.getMessage()};
            throw new SDXException(this.getLog(), 8204, args, ee);
        }
        zos.close();
    }

    public void restore(SaveParameters save_config) throws SDXException {
        if (save_config != null) {
            File file;
            String repo_path = save_config.getStoreCompletePath();
            if (save_config.getAttributeAsBoolean("all", false) && (file = new File(repo_path + File.separator + "repo.zip")).exists()) {
                this.restoreRepositoryData(file);
            }
        }
    }

    /*
     * Loose catch block
     */
    private void restoreRepositoryData(File file) throws SDXException {
        RepositoryConnection sqlrepoConn = this.getConnection();
        Connection conn = ((JDBCRepositoryConnection)sqlrepoConn).getConnection();
        ZipFile zf = null;
        zf = new ZipFile(file);
        ZipInputStream zis_temp = null;
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        int len = 0;
        byte[] b_temp = new byte[1024];
        ByteArrayOutputStream bo_id = new ByteArrayOutputStream();
        ByteArrayOutputStream bo_blob = new ByteArrayOutputStream(512);
        st.executeUpdate("DELETE FROM " + this.getTableName());
        Enumeration<? extends ZipEntry> _enum = zf.entries();
        while (_enum.hasMoreElements()) {
            ZipEntry ze = _enum.nextElement();
            zis_temp = new ZipInputStream(zf.getInputStream(ze));
            while (zis_temp.getNextEntry() != null) {
                boolean end_id = false;
                bo_id.reset();
                bo_blob.reset();
                while ((len = zis_temp.read(b_temp)) > 0) {
                    if (!end_id) {
                        for (int i = 0; i < len && !end_id; ++i) {
                            if (b_temp[i] != 10) continue;
                            end_id = true;
                            bo_id.write(b_temp, 0, i);
                            bo_blob.write(b_temp, i + 1, len - i - 1);
                        }
                        continue;
                    }
                    bo_blob.write(b_temp, 0, len);
                }
                String queryString = this.getDocumentAddQuery();
                JDBC.Template template = new JDBC.Template(conn, queryString);
                final String docId = bo_id.toString();
                final ByteArrayInputStream is = new ByteArrayInputStream(bo_blob.toByteArray());
                final int length = ((InputStream)is).available();
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                    public void prepare(PreparedStatement ps) throws SQLException {
                        ps.setString(1, docId);
                        ps.setBinaryStream(2, is, length);
                    }
                };
                template.execute(qe, 1);
            }
            zis_temp.close();
        }
        conn.commit();
        Object var21_29 = null;
        try {
            if (conn != null) {
                conn.setAutoCommit(true);
            }
            zf.close();
        }
        catch (SQLException ee) {
            String[] args = new String[]{this.getId(), ee.getMessage()};
            throw new SDXException(this.getLog(), 8204, args, ee);
        }
        catch (IOException ee) {
            String[] args = new String[]{this.getId(), ee.getMessage()};
            throw new SDXException(this.getLog(), 8204, args, ee);
        }
        {
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException ee) {
                    String[] args = new String[]{this.getId(), ee.getMessage()};
                    throw new SDXException(this.getLog(), 8204, args, ee);
                }
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, e);
            }
            catch (IOException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException ee) {
                    String[] args = new String[]{this.getId(), ee.getMessage()};
                    throw new SDXException(this.getLog(), 8204, args, ee);
                }
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var21_30 = null;
            try {
                if (conn != null) {
                    conn.setAutoCommit(true);
                }
                zf.close();
            }
            catch (SQLException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, ee);
            }
            catch (IOException ee) {
                String[] args = new String[]{this.getId(), ee.getMessage()};
                throw new SDXException(this.getLog(), 8204, args, ee);
            }
            this.releaseConnection(sqlrepoConn);
            throw throwable;
        }
        this.releaseConnection(sqlrepoConn);
    }
}

