/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.JDBCDatabase;
import fr.gouv.culture.sdx.utils.save.SaveParameters;

public class MYSQLDatabase
extends JDBCDatabase {
    protected final String FIELD_KEY = "sdx_key";

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "sdx_key" + " INT AUTO_INCREMENT, " + "PRIMARY KEY (" + "sdx_key" + "))";
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("Database_Type", "MYSQLDatabase");
        this._xmlizable_objects.put("JDBC_Table_Name", this.tableName);
        this._xmlizable_objects.put("Data_Source_Identifier", this.dsi);
        return true;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "MYSQL");
        }
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT * FROM " + this.getTableName();
        query = query + " LIMIT " + String.valueOf(offset) + "," + String.valueOf(number) + ";";
        return query;
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

