/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import java.sql.Connection;
import java.sql.SQLException;

public class SQLDatabaseConnection
extends AbstractSdxObject
implements DatabaseConnection {
    Connection conn = null;

    public SQLDatabaseConnection() {
    }

    public SQLDatabaseConnection(Connection conn) {
        this.conn = conn;
    }

    public void commit() throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            throw new SDXException(super.getLog(), 224, null, e);
        }
    }

    public void rollback() throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.rollback();
            }
        }
        catch (SQLException e) {
            throw new SDXException(super.getLog(), 225, null, e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            throw new SDXException(super.getLog(), 226, null, e);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void close() throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new SDXException(super.getLog(), 224, null, e);
        }
    }

    public void optimize() throws SDXException {
    }

    protected String getClassNameSuffix() {
        return "DatabaseConnection";
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

