#import "PopObsSwarm.h"
#import "PopBatchSwarm.h"

#define GENLEN 4

float evalFunc( id<Chromosome> a );

int
main(int argc, char ** argv) {
  id topLevelSwarm;

  initSwarm(argc, argv);

  if ( swarmGUIMode == 1 ) {
    topLevelSwarm = [PopulationObserverSwarm create: globalZone];
  } else {
    topLevelSwarm = [PopulationBatchSwarm create: globalZone];
  }
  [topLevelSwarm setChromLength: GENLEN];
  [topLevelSwarm setEvaluationFunc: evalFunc];
  [topLevelSwarm buildObjects];
  [topLevelSwarm buildActions];
  [topLevelSwarm activateIn: nil];
  [topLevelSwarm go];

  return 0;
}

// Evaluation function. Name can be different, but the structure must always
// be the same, that is, called with the same arguments and returning the same
//  value. This function is called only once in the lifetime of
// each different genome
float evalFunc( id<Chromosome> a ) {
    unsigned i;
    float ones = 0;
    unsigned long gen, mask = 1;

    // Using getGene we retrieve the different bytes of the chromosome. 
    // If one parameter uses several bytes, like here, use shifts and
    // multiplication to get its value.

    gen = ((long)[a getGene:0]<<24) 
      + ((long)[a getGene:1]<<16) + 
      ((long)[ a getGene:2 ]<<8) + [ a getGene:3 ];
    for ( i = 0; i < 8*GENLEN; i ++ ) {
	ones += ( ( mask & gen ) != 0 );
	mask <<= 1;
    }

    return ones;
}
