// -*- mode: objc; -*-
// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#ifndef _BINCHROM_H
#define _BINCHROM_H

// Several things used throughout the library
#import <defobj.h>       // For UniformRandom
#import <simtools/global.h>
#import <objectbase/SwarmObject.h> // for SwarmObject

//Standard includes
#include <stdio.h>

#define BITSINBYTE 8
#define IDLEN 10
#define LASTBYTEN 7
#define MAX8BITS 256

#import "Chromosome.h"		// Implements Chromosome protocol

@interface BinChromosome: SwarmObject <Chromosome> {
  unsigned char *genotype;
  float fitness;		
  char ID[IDLEN];		// Unique id generated by uname 
  unsigned length;
}

// Overriden from SwarmObject
-createEnd;			
-(void) drop;
@end

#endif
