// -*- mode: objc-mode
// Template application. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase.h>		// For Swarm
#import <simtools.h>		// For probes
#import <analysis.h>		// For EZGraph
#import <activity.h>		// For swarmActivity

#import "PopSwarm.h"

// Batch interface for a GA-population swarm
@interface PopulationBatchSwarm : Swarm {
  unsigned loggingFrequency;	// File i/o frequency
  unsigned generations;		// Number of generations
  
  id displayActions;
  id displaySchedule;
  
  // MODIFY: add display objects
  unsigned chromLen;
  float (*evalFunc) (id<Chromosome>); // Evaluation Function
  PopulationSwarm * populationSwarm;

  id fitnessGraph;		// graphing widget, used in file I/O mode

}

+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

// Other methods
-setChromLength: (unsigned) _len;
-setEvaluationFunc: (float(*)( id )) _evalFunc;
-checkToStop;
-go;
@end
