// World.h
// builds World of agents and manages agent interaction 

#import "gameworld.h"
#import "Interact.h"
#import "PopStep.h"
#import "Sort.h"
#import <space/Grid2d.h>

@interface World : Grid2d
{
// xsize, ysize are from Grid2d class
  int num_agents;				  // num agent in world
  id * player;					  // array of players
  id * tmpArray;				  // array used for sorting agents

  double avg_score;
  Interact * compete;				  // object for agent interaction
  PopStep * update;				  // next generation
  Sort * sort;					  // sort agents
}

-setNumberAgents: (int) pop;
-setPlayers: (id *) players;
-setInteract: (Interact *) compete;
-setPopStep: (PopStep *) ga;
-setSort: (Sort *) sorter;
-setTmpArray;

-stepSpatial;
-(double) computeSpatialAverage;

-(id) getAgent: (int) i;
-(double) getAverage;

-printSpatialStrategies;
-printSpatialWorld;

@end
