// Interact.h
// defines interaction of agents within World

#import "Agent.h"
#import <objectbase/SwarmObject.h>
#import <space/Grid2d.h>

@interface Interact: SwarmObject
{
  int num_iter;			// num iters finding avg value
  double error;			// % of flipped agent actions
}

-setIterations: (int) iter;
-setError: (double) err;

-spatialInteract: (Grid2d *) a X: (int) xsize Y: (int) ysize;
-agentSpatialInteract: (id) player1 vs: (id) player2;
-agentInteract: (id) player1 vs: (id) player2;

-(int) getIterations;
-(double) getError;

@end
