// GA.m
// code for methods belonging to GA object class

#import "GA.h"
#import "r250.h"

@implementation GA

// genotype bit operators

-(int) bitMutate: (int) gene len: (int) length
{
  int k,m;
  
  k = r250() % length;				  // which bit to mutate
  m = 1 << k;
  if ( m & gene) {				  // if mutation position is 1
    k = m ^ 0xffffffffU;
    return (gene & k);
  } else {
    return (gene | m);
  }
}

-(int) doubleMutate: (int) gene len: (int) length
{
  return ( (gene << length) | gene );
}

-(int) splitMutate: (int) gene len: (int) length
{
  int m,n;
  
  length >>=1;					  // new length
  m = (1 << length) - 1;			  // mask of new mem length
  if ( dr250() >= 0.5){
    return (m & gene);
  } else {
    n = (m << length) & gene;
    return (n >> length) & m;			  // why does >> bring in 1s?
						  // if I don't have & m, is wrong
  }
}

-(int) crossMutate: (int *) g1 gene2: (int *) g2 len1: (int) l1 len2: (int) l2
{
  int t1,c1,k1;
  
  if (l1 == l2) {				  // have same length strategies
    k1 = l1 >> 1;				  // half length
    t1 = (1 << k1) - 1;				  // mask of 1/2 strategy

    c1 = *g1;
  
    *g1 = ( c1 & (t1 << k1) ) | (*g2 & t1);
    *g2 = ( *g2 & (t1 << k1) ) | (c1 & t1);

    // printf("l1==l2 mask 0x%x\n",t1);			  
    // printf("inside:: g1: 0x%x l1: %d g2: 0x%x l2: %d\n",*g1,l1,*g2,l2);

    return (l1);				  // return actual length

  } else if ( dr250() <= 0.5) {			  // use g1 as basis
    k1 = l1 >> 1;
    t1 = (1 << k1) - 1;				  // mask of 1/2 strategy g1

    c1 = *g1;					  // equalize length
    while (l1 > l2) {
      *g2 = [self doubleMutate: *g2 len: l2];
      l2 <<=1;
    }
    while (l1 < l2) {
      *g2 = [self splitMutate: *g2 len: l2];
      l2 >>=1;
    }

    // printf("l1 mask 0x%x\n",t1);			  
    // printf("inside:: g1: 0x%x l1: %d g2: 0x%x l2: %d\n",*g1,l1,*g2,l2);
      
    *g1 = ( c1 & (t1 << k1) ) | (*g2 & t1);
    *g2 = ( *g2 & (t1 << k1) ) | (c1 & t1);
      
    return (l1);

  } else {					  // use g2 as basis
    k1 = l2 >> 1;
    t1 = (1 << k1) - 1;				  // mask of 1/2 strategy g2

    c1 = *g2;					  // equalize length
    while (l2 > l1) {
      *g1 = [self doubleMutate: *g1 len: l1];
      l1 <<=1;
    }
    while (l2 < l1) {
      *g1 = [self splitMutate: *g1 len: l1];
      l1 >>=1;
    }

    // printf("l2 mask 0x%x\n",t1);			  
    // printf("inside:: g1: 0x%x l1: %d g2: 0x%x l2: %d\n",*g1,l1,*g2,l2);

    *g2 = ( c1 & (t1 << k1) ) | (*g1 & t1);
    *g1 = ( *g1 & (t1 << k1) ) | (c1 & t1);
      
    return (l2);
  }
}

@end








