// $Id: DetectorFeed.m,v 1.1 2001/01/22 15:10:00 ralf Exp $

#import "DetectorFeed.h"
#import "Detector.h"

@implementation DetectorFeed

//----------------------------------
+createBegin: aZone 
{
	DetectorFeed *obj = [super createBegin: aZone];
	obj->myList = [List create: aZone];
	obj->count = 0;
	return obj;
}

-(void)setMin: (float) x1 Max: (float) x2
{
	myMin = x1;
	myMax = x2;
}

-(void)addObj: anObj
{
	[myList addLast: anObj];
	++count;
}

-createEnd
{
	id index, member;
	int offs=0;
	
	myArr = [Array create: [self getZone] setCount: count];

	index = [myList begin: scratchZone];
	for (member = [index next]; [index getLoc] == Member; member = [index next])
		if (member)
			[myArr atOffset: offs++ put: member];
			
	[index drop];
	[myList drop];
	return [super createEnd];
}

//------------------------------------
-(BOOL)getDFrom: (double*) x : (double*) y
{
	float dist = (myMax-myMin)/(count-1);
	int offs = (int)((*x-myMin+(dist/2))/dist);
	*y = [[myArr atOffset: offs] getFlow];
	return YES;
}

@end
