// MNGVideo.m - (c) 2001 R. Stephan <ralf@ark.in-berlin.de>
// distributed under GPL2, see http://www.gnu.org
// $Id: MNGVideo.m,v 1.8 2001/01/25 10:39:52 ralf Exp $

#include <stdlib.h>
#import "MNGVideo/MNGVideo.h"
#import "mngutil.h"

@implementation MNGVideo

//----------------------------------------------------

+create: aZone Grid: (id <Grid2d>) w MagFactor: (unsigned) m
   ColorMap: (id <Colormap>) c
{
  MNGVideo *obj = [MNGVideo createBegin: aZone];
  [obj setGrid: w];
  [obj setMagnification: m];
  [obj setColormap: c];
  return [obj createEnd];
}

+create: aZone Grid: (id <Grid2d>) w MagFactor: (unsigned) m
   ColorMap: (id <Colormap>) c FrameRate: (unsigned) rate NFrames: (int) nf
   Basename: (unsigned char*) name
{
  MNGVideo *obj = [MNGVideo createBegin: aZone];
  [obj setGrid: w];
  [obj setMagnification: m];
  [obj setColormap: c];
  [obj setFrameRate: rate];
  [obj setNFrames: nf];
  [obj setBasename: name];
  return [obj createEnd];
}

+createBegin: aZone
{
  MNGVideo *obj = [super createBegin: aZone];
  obj->width = obj->height = obj->mag = obj->fps = obj->n_frames = 0;
  obj->buf = 0;
  obj->img_nr = -1;
  obj->world = nil;
  obj->colormap = nil;
  obj->basename = nil;
  return obj;
}

-createEnd
{  // nil colormap means black/white
  [self setGrid: world]; // checks w,h too
  if (mag<=0) [self setMagnification: 1];
  if (fps<=0) [self setFrameRate: 10];
  if (n_frames<=0) [self setNFrames: 100];
  if (basename==nil) [self setBasename: "swarm"]; // opens file too

  return [super createEnd];
}

//---------
-setGrid: (id <Grid2d>) w
{
  if (w == nil)
    raiseEvent (InvalidArgument, "> argument is nil\n");
  
  world = w;
  if (height <= 0)
    height = [world getSizeY];
  if (width <= 0)
    width = [world getSizeX];

  return self;
}

-setColormap: (id <Colormap>) c
{
  colormap = c;
  if (colormap)
    fprintf (stderr, "Warning: color video not implemented\n");
  return self;
}

-setBasename: (char*) filebase
{
  if (filebase == NULL)
    fprintf (stderr, "Warning: attempt to set MNGVideo::basename=nil\n");
  if (basename) [basename drop];
  if (filename) [filename drop];

  basename = [String create: [self getZone] setC: filebase];
  filename = [String create: [self getZone] setC: filebase];
  [filename catC: ".mng"];

  // check if we can write file
  file_p = fopen ([filename getC], "w");
  if (!file_p)
    fprintf (stderr, "Couldn't fopen file %s\n", [filename getC]);

  return self;
}

-setWidth: (unsigned) w
{
  if (w<=0)
    fprintf (stderr, "Warning: attempt to set MNGVideo::width=%d\n", w);

  width = w;
  return self;
}

-setHeight: (unsigned) h
{
  if (h<=0)
    fprintf (stderr, "Warning: attempt to set MNGVideo::height=%d\n", h);

  height = h;
  return self;
}

-setMagnification: (int) m
{
  if (m<=0)
    fprintf (stderr, "Warning: attempt to set MNGVideo::mag=%d\n", m);

  mag = m;
  return self;
}

-setFrameRate: (int) rate
{
  if (rate <= 0 || rate > 100)
    fprintf (stderr, "Warning: attempt to set MNGVideo::fps=%d\n", rate);

  fps = rate;
  return self;
}

-setNFrames: (int) nf
{
  if (nf <= 0)
    fprintf (stderr, "Warning: attempt to set MNGVideo::n_frames=%d\n", nf);

  n_frames = nf;
  return self;
}

//-----------------------------------------------------

-(int) initVideo
{
// returns -1 on failure
  png_ptr = png_create_write_struct (PNG_LIBPNG_VER_STRING, 
				    (png_voidp)NULL, 
				    (png_error_ptr)NULL, 
				    (png_error_ptr)NULL);
  if (!png_ptr) return -1;

  info_ptr = png_create_info_struct (png_ptr);
  if (!info_ptr)
    return -1;
  
  if (setjmp (png_ptr->jmpbuf))
    return -1;

  png_set_IHDR (png_ptr, info_ptr, width, height, 1, 
		PNG_COLOR_TYPE_GRAY,
		PNG_INTERLACE_NONE,
		PNG_COMPRESSION_TYPE_DEFAULT,
		PNG_FILTER_TYPE_DEFAULT);

  png_init_io (png_ptr, file_p);
  mng_write_sig (png_ptr);
  mng_write_MHDR (png_ptr, width*mag, height*mag, fps, 0x07);
  mng_write_FRAM (png_ptr, 1, NULL, 2, 0, 0, 0, 1);

  return 0;
}

-(void) takeAFrame
{
  if (++img_nr == 0)  // first call
    if ([self initVideo] < 0)
      fprintf (stderr, "MNGVideo.m: Couldn't init libpng!\n");

  if (img_nr >= n_frames) {
    [self finish];
    return;
  }

  if (png_ptr)
    png_destroy_write_struct (&png_ptr, (png_infopp)NULL);
  png_ptr = png_create_write_struct (PNG_LIBPNG_VER_STRING,
				(void *)NULL, NULL, NULL);
  if (!png_ptr) 
    fprintf (stderr, "MNGVideo.m: Couldn't make png_ptr\n");

  png_init_io (png_ptr, file_p);
  mng_write_MAGN (png_ptr, 0, mag);
  mng_write_DEFI (png_ptr, 0);
  // TODO: test if they can be left out, could save 10 bytes per frame

  png_set_compression_level (png_ptr, Z_BEST_COMPRESSION);
  png_set_sig_bytes (png_ptr, 8);
  info_ptr->width = width;
  info_ptr->height= height;
  info_ptr->bit_depth = 1;
  info_ptr->color_type = PNG_COLOR_TYPE_GRAY;
 
  if (png_get_valid (png_ptr, info_ptr, PNG_INFO_sBIT)) {
    png_color_8p sig_bit;
    png_get_sBIT (png_ptr, info_ptr, &sig_bit);
    sig_bit->gray = 1;
    png_set_sBIT (png_ptr, info_ptr, sig_bit);
  }

  png_set_filter (png_ptr, 0,
		  PNG_FILTER_NONE | PNG_FILTER_SUB |
		  PNG_FILTER_PAETH);
  png_set_packing (png_ptr);

  png_write_info (png_ptr, info_ptr);

  if (buf == 0)
    buf = (png_byte **)malloc (sizeof(png_byte*)*height);
  if (!buf) 
    fprintf (stderr, "MNGVideo.m: Couldn't malloc buf!\n");

  { int x,y;
  for (y=0; y<height; ++y)
    if ((buf[y] = (png_byte *)malloc (sizeof(png_byte)*(width/8)+1)) == NULL)
      fprintf (stderr, "MNGVideo.m: Couldn't malloc buf!\n");

  for (y=0; y<height; ++y)
    for (x=0; x<width; ) {
      int bit, byte=0;
      for (bit=0; bit<8; ++bit,++x) 
	byte = (byte<<1) + ([world getObjectAtX: x Y: y]!=nil);
      buf[y][x/8-1] = byte;
    }
  }

  //  fprintf (stderr, "\nI%05d: \n", ++img_nr);
  //  fflush (stderr);
  png_write_image (png_ptr, buf);
  png_write_end (png_ptr, info_ptr);
}

-(void) finish
{
  if (file_p) {
    mng_write_MEND (png_ptr);
    fclose (file_p);
    file_p = 0;
  }
}

-(void) drop
{
  [self finish];
  if (buf) free (buf);
  if (basename) [basename drop];
  if (filename) [filename drop];
}

@end

// $Log: MNGVideo.m,v $
// Revision 1.8  2001/01/25 10:39:52  ralf
// include header from subdir
//
// Revision 1.7  2001/01/24 17:19:43  ralf
// * MNGVideo.m: return from takeAFrame when finished
//
// Revision 1.6  2001/01/24 17:01:52  ralf
// added png/mng code from traffic.c, 1st compile/run
//
// Revision 1.5  2001/01/23 17:30:39  ralf
// * MNGVideo.m:
// * MNGVideo.h: this compiles now, 1st design complete
//
// Revision 1.4  2001/01/23 16:14:03  ralf
// * MNGVideo.m: this compiles now
//
// Revision 1.3  2001/01/23 16:05:54  ralf
// * MNGVideo.m: this compiles now
//
// Revision 1.2  2001/01/22 16:12:57  ralf
// *** empty log message ***
//
