/* $Id: mngutil.c,v 1.2 2001/01/24 17:04:31 ralf Exp $
 * mngutil.c, vi: tabstop=4
 *
 * Copyright (C) 1997-98 Rasca, Berlin
 * EMail: thron@gmx.de
 * With changes (C) 2001 R.Stephan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <zlib.h>
#include <png.h>
#include "mngutil.h"

extern void png_write_data (png_structp png_ptr,
				png_bytep data,png_size_t length);
extern void png_save_uint_32 (png_bytep buf, png_uint_32 i);
extern void png_save_uint_16 (png_bytep buf, png_uint_16 i);
extern void png_write_chunk (png_structp png_ptr,
				png_bytep chunk_name, png_bytep data, png_size_t length);

png_byte mng_sig[8] = {138, 77, 78, 71, 13, 10, 26, 10};

/*
 * write MNG signature
 */
void
mng_write_sig (png_structp png_ptr)
{
	/* write the rest of the 8 byte signature */
	png_write_data (png_ptr, &mng_sig[png_ptr->sig_bytes],
		(png_size_t)8 - png_ptr->sig_bytes);
}


/*
 * write the MHDR header to the file
 */
void
mng_write_MHDR (png_structp png_ptr, int width, int height, int tick, int simp)
{
	png_byte buff[32];
	png_save_uint_32 (buff,   width);
	png_save_uint_32 (buff+4, height);
	png_save_uint_32 (buff+8, tick);
	png_save_uint_32 (buff+12, 0);
	png_save_uint_32 (buff+16, 0);
	png_save_uint_32 (buff+20, 0);
	png_save_uint_32 (buff+24, simp);
	png_write_chunk (png_ptr, "MHDR", buff, (png_size_t)28);
}

/*
 * write the MEND chunk to the file
 */
void
mng_write_MEND (png_structp png_ptr)
{
	png_write_chunk (png_ptr, "MEND", NULL, (png_size_t)0);
}

/*
 * short version .. not all parameters for the DEFI chunk
 * are suported
 */
void
mng_write_DEFI (png_structp png_ptr, unsigned short id)
{
	png_byte buff[2];
	png_save_uint_16 (buff,   id);
	png_write_chunk (png_ptr, "DEFI", buff, (png_size_t)2);
}

/*
 * short version .. not all parameters for the FRAM chunk
 * are supported
 */
void
mng_write_FRAM (png_structp png_ptr, char framing_mode, char *name,
	char chg_interframe_delay, char chg_sync_timeout,
	char chg_frame_clipping_boundaries, char chg_sync_id_list,
	png_uint_32 interframe_delay)
{
	png_byte *buff;
	int len = 1;

	if (name)
		len = strlen (name) + 1;
	buff = malloc (len + 9);
	buff[0] = framing_mode;
	if (name)
		strcpy (buff+1, name);
	else
		buff[1] = 0;
	buff[len+1] = chg_interframe_delay;
	buff[len+2] = chg_sync_timeout;
	buff[len+3] = chg_frame_clipping_boundaries;
	buff[len+4] = chg_sync_id_list;
	png_save_uint_32 (buff+len+5, interframe_delay);
	png_write_chunk (png_ptr, "FRAM", buff, (png_size_t)(len+9));
}

void
mng_write_MAGN (
		png_structp png_ptr,
		unsigned short id,
		unsigned short mag)
{
  png_byte buff[32];
  int len;

  png_save_uint_16 (buff, id);
  png_save_uint_16 (buff+2, id);
  png_save_uint_16 (buff+4, 1); // pixel replication
  png_save_uint_16 (buff+6, mag);
  //  png_save_uint_16 (buff+7, 0);
  //  png_save_uint_16 (buff+9, 0);
  //  png_save_uint_16 (buff+11, 0);
  //  png_save_uint_16 (buff+13, 0);
  //  png_save_uint_16 (buff+15, 0);
  //  buff[17] = 0;

  png_write_chunk (png_ptr, "MAGN", buff, 8);}
  

/*
 * short version .. does not support all parameters
 */
void
mng_write_CLON (
	png_structp png_ptr,
	unsigned short source_id, unsigned short clone_id,
	unsigned char clone_type)
{
	png_byte buff[5];
	int len;

	png_save_uint_16 (buff, source_id);
	png_save_uint_16 (buff+2, clone_id);

	if ((clone_type > 1) || (clone_type == 0)) {
		len = 4;
	} else {
		len = 5;
		buff[4] = clone_type;
	}
	png_write_chunk (png_ptr, "CLON", buff, (png_size_t)len);
}

/*
 * SHOW chunk .. short version
 */
/*
void
mng_write_SHOW (png_structp png_ptr, unsigned short first, unsigned short last)
{
	png_byte buff[4];
	int len;
	png_save_uint_16 (buff, first);
	png_save_uint_16 (buff+2, last);
	if (!last)
		len = 2;
	else
		len = 4;
	png_write_chunk (png_ptr, "SHOW", buff, (png_size_t)len);
}
*/

/*
 */
void
mng_write_nEED (png_structp png_ptr, char *string)
{
	int len;
	if (!string)
		return;
	len = strlen (string);
	png_write_chunk (png_ptr, "nEED", string, (png_size_t)len+1);
}


