#import <objectbase/SwarmObject.h>
#import <space.h>
#import <collections.h>
#import <tkobjc/Raster.h>
#import "Species.h"

@interface Agent: SwarmObject
{
@protected
	id <Grid2d> myWorld;               // fixed
	int worldXSize, worldYSize;
	Species* mySpecies;
	double myEnergy;
	double myConsumption;
	double myEnergy2Spawn;
	
	int posX, posY;                  // mutable
	Color myColor;
}

+ createBegin: aZone;
- (void) setWorld: (id <Grid2d>) aWorld;
- (void) setSpecies: aSpecies;
- (void) setEnergy: (double) d;        
- (void) setEnergy2Spawn: (double) d;
- (void) setConsumption: (double) d;
- (void) copyFStateInto: (Agent*)anAgent;
- createEnd;
- (void) copyMStateInto: (Agent*)anAgent;
- setX: (int) x Y: (int) y;
- (void) setEnergy: (double) d;
- setColor: (Color) c;
- (void) print;

@end
