#import "Agent.h"

//-----------------------------------------------------------------
@implementation Agent

+createBegin: (id) aZone
{
	id obj = [super createBegin: aZone];
	return obj;
}	

-(void) setWorld: (id <Grid2d>) aWorld
{
	myWorld = aWorld;
	worldXSize = [myWorld getSizeX];
	worldYSize = [myWorld getSizeY];
}

-(void) setConsumption: (double)d
{
	myConsumption = d;
}

-(void) setEnergy2Spawn: (double) d
{
	myEnergy2Spawn = d;
}

-(void) setSpecies: (Species*) aSpecies
{
	mySpecies = aSpecies;
}

-(void) copyFStateInto: (Agent*) anAgent
{
	[anAgent setWorld: myWorld];
	[anAgent setSpecies: mySpecies];
	[anAgent setConsumption: myConsumption];
	[anAgent setEnergy2Spawn: myEnergy2Spawn];
}

-createEnd
{
	return [super createEnd];
}

//-----------------
-(void) copyMStateInto: (Agent*) anAgent
{
	[anAgent setX: posX Y: posY];
	[anAgent setColor: myColor];
	[anAgent setEnergy: myEnergy];
}

- setX: (int)x Y: (int)y
{
	posX = x;
	posY = y;
	return self;
}

-(void) setEnergy: (double)d
{
	myEnergy = d;
}

-setColor: (Color) c
{
	myColor = c;
	return self;
}

-(void) print 
{
  printf("x=%d y=%d energy=%3.2f\n", posX, posY, myEnergy);
}

- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: posX Y: posY Color: myColor];

  return self;
}


