// $Id: NaSchSingleCar.m,v 1.1 2001/03/27 16:35:06 ralf Exp $

#import "NaSchSingleCar.h"
#import <space.h>
#import <random.h>
#import "Detector.h"

@implementation NaSchSingleCar
//---------------------
-(void)accelerate
{
	if (myV < myVMax) ++myV;
}

-(void)brake
{
	int x,v;
	
	if (myV == 0) return;

	x = myX;
	v = 0;
	while (++v <= myV)
	{
		if (++x >= myWorldSize) x=0;
		if ([myWorld getObjectAtX: x Y: myY] != nil)
		{
			myV = v-1;
			return;
		}
	}
}

-(void)randomize
{
	if (myV > 0
		&& [uniformIntRand getIntegerWithMin: 1 withMax: 100] <= myPDecel*100)
		--myV;
}

-(void)drive
{
	int newX = myX + myV;
	if (newX >= myWorldSize) newX -= myWorldSize;
	[myWorld putObject: nil atX: myX Y: myY];
	[myWorld putObject: self atX: newX Y: myY];
	if (myX < myDetX && newX >= myDetX)
		[myDetector trigger];
	myX = newX;
}


