// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// kksom es muy parecido, pero usa graficos diferentes:
// La version 2 usa la nueva version de BLTGRAPH...
// Last version uses SOMplus, instead of the plain vanilla SOM

#import <simtools.h>
#import <simtoolsgui.h>
#import <random.h>
#import <gui.h>

#include "SOMplus.h"

#include <sys/types.h>

#define INPUTSIZE 2

#define NUMVARS 7

#define WIDTH 400
#define HEIGHT 250

char *Colors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
};

int
main (int argc, const char **argv)
{
  unsigned numNeurons = 10;
  double alpha = 0.2;
  double alphaMult = 0.995;
  unsigned initialNHood = 4;
  unsigned selfOrg = 1000;
  unsigned totSteps = 10000;
  int dashes = 0;
  
  id aZone;			// Allocation zone
  SOMplus* neura;			// Neural network
  unsigned i;
  id <Graph> wgtGraph;
  id <GraphElement> wgtData;
  Frame * aFrame;
  id <Entry> entry[NUMVARS]; // To get number of neurons
  id <Label> label[NUMVARS];
  char Labels[NUMVARS][30] = {"Number of neurons", "Alpha initial value",
			      "Alpha multiplier", "Initial neighborhood",
			      "Total steps", "Steps self-organizing phase",
			      "Dashed lines" };
  id <ControlPanel> controlPanel;
  id <ActionCache> actionCache;
#if 0
  id displayActions;
  id displaySchedule;
#endif

  // Initialize swarm and zones
  initSwarm (argc, argv);
  aZone = [Zone create: globalZone];

  // Create entry forms
  aFrame=[Frame create: globalZone];
  for (i = 0; i < NUMVARS; i++)
    {
      entry[i] = [Entry createParent: aFrame ];  
      [entry[i] pack];
      label[i] = [Label createParent: aFrame];
      [[label[i] setText: Labels[i]] pack];
    }
  // Now assign types and variables
  [entry[0] linkVariableInt: &numNeurons];
  [entry[1] linkVariableDouble: &alpha];
  [entry[2] linkVariableDouble: &alphaMult];
  [entry[3] linkVariableInt: &initialNHood];
  [entry[4] linkVariableInt: &totSteps];
  [entry[5] linkVariableInt: &selfOrg];
  [entry[6] linkVariableBoolean: &dashes];

  // Create Graph
  wgtGraph = [Graph create: aZone];
  [wgtGraph setWidth: WIDTH Height: HEIGHT];
  [wgtGraph setRangesXMin: -1.5 Max:1.5 YMin:-1.5 Max :1.5];
  [wgtGraph setTitle: "Weight Wandering" ];
  [wgtGraph setAxisLabelsX: "WeightX" Y: "WeightY"];

  // lines and points
  wgtData = [wgtGraph createElement];
  [wgtData setLabel: "Weights" ];
  [wgtData setColor: "Green"];
  [wgtData setSymbol: "circle" ];
  [wgtData setDashes: dashes];

  // Pack them together 
  [wgtGraph pack];

  // actions and controlpanel
  controlPanel = [ControlPanel create: globalZone];
  actionCache = [ActionCache createBegin: globalZone];
  [actionCache setControlPanel: controlPanel];
  actionCache = [actionCache createEnd];

  [actionCache waitForControlEvent];

#if 0
  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: globalZone];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  displaySchedule = [Schedule createBegin: globalZone];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
#endif

  // Create neural neurat network
  neura = [SOMplus createBegin: aZone];
  [neura setLayerSize: INPUTSIZE: numNeurons ];	// 3rd one does not matter
  [neura setRandomWeights];
  [neura setAlpha: (float) alpha Mult: (float) alphaMult];
  [neura setInitialNHood: initialNHood];
  [neura setSelfOrg: selfOrg];

  if (!( neura = [neura createEnd]))
    [InvalidCombination raiseEvent: "NN not created"]; 
  
  i = 0; 
  while ([controlPanel getState] != ControlStateQuit) 
    {
      unsigned j;
      float inp[INPUTSIZE];

      while ([controlPanel getState] != ControlStateRunning)
        [actionCache waitForControlEvent]; 

      [actionCache doTkEvents];
      [actionCache deliverActions];
      
      for (j = 0; j < INPUTSIZE; j++)
        inp[j] =  (float)[uniformDblRand getDoubleWithMin:-1.0L withMax: 1.0L];
      
      // SOM network feeding and training
      [neura feedForward: inp];
      [neura train: 0];
      
      if (i) 		   // After the first iteration
        [wgtData resetData];
      
      for (j = 0; j < numNeurons; j++)
        {
          float w1, w2;
          
          w1 = [neura getWeights: j: 0 ];
          w2 =  [neura getWeights: j: 1 ]; 
          [wgtData addX: w1 Y:  w2];
        }
      
      i++;
    }
  exit (0);
}
