// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// Version kkheb2ly es igual, pero para una hebbiana de dos capas...

// Now compiles cleanly for swarm version 0807

// kkcl.m es una adaptacion, para probar CompLearning

#import <simtools.h>
#import <random.h>
#import <simtoolsgui.h>
#import <gui.h>

#import "CRNN.h"		// CRNN declarations
#include <misc.h>

#define WIDTH 400
#define HEIGHT 250
//___________________________________________________________
int
main (int argc, const char **argv)
{
  unsigned numNeurons = 2;

  id neura;			// Neural network
  id <Entry> aEntry;		// To get number of neurons
  id <Label> aLabel;
  id <ControlPanel> controlPanel;	// Usually in GUISwarm
  id <ActionCache> actionCache;

  id displayActions;
  id displaySchedule;
  unsigned j;
  float *inp, *oldOut, *out;	// Generic input vector
  
  id <Graph> wgtGraph, attrGraph;
  id <GraphElement> wgtData, ptData, attrData;
  
  // Initialize swarm
  initSwarm (argc, argv);
  
  aEntry=[Entry create: globalZone];
  [aEntry linkVariableInt: &numNeurons];
  [aEntry pack];
  aLabel = [Label createParent:[aEntry getParent]];
  [aLabel setText: "Number of neurons" ];
  [aLabel pack];

  // Create Graph
  wgtGraph = [Graph create: globalZone];
  [wgtGraph setWidth: WIDTH Height: HEIGHT];
  [wgtGraph setRangesXMin: -1.5 Max:1.5 YMin:-1.5 Max :1.5];
  [wgtGraph setTitle: "Activation wandering" ];
  [wgtGraph setAxisLabelsX: "neuron 0" Y: "neuron 1"];
  
  // lines and points
  ptData = [wgtGraph createElement];
  [ptData setLabel: "Latest Value" ];
  [ptData setColor: "Blue"];
  [ptData setSymbol: "diamond"];  
  wgtData = [wgtGraph createElement];
  [wgtData setLabel: "Activation" ];
  [wgtData setColor: "Red"];
  [wgtGraph pack];
  
  // Attractor graph
  attrGraph = [Graph createParent: [wgtGraph getParent]];
  [attrGraph setWidth: WIDTH Height: HEIGHT];
  [attrGraph setTitle: "Attractors" ];
  [attrGraph setAxisLabelsX: "neuron 0" Y: "neuron 1"];
  
  attrData = [attrGraph createElement];
  [attrData setLabel: "Attractors" ];
  [attrData setColor: "Green"];
  [attrData setSymbol: "scross"];
  [attrGraph pack];
  
  // actions and controlpanel
  controlPanel = [ControlPanel create: globalZone];
  // create the actionCache, we will initialize it in activateIn
  actionCache = [ActionCache createBegin: globalZone];
  [actionCache setControlPanel: controlPanel];
  actionCache = [actionCache createEnd];   

  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: globalZone];
  [displayActions createActionTo: controlPanel message: M(doTkEvents)];
  displaySchedule = [Schedule createBegin: globalZone];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  // Neural network
  neura = [CRNN createBegin: globalZone];
  [neura setNumberNeurons: numNeurons ]; 
  [neura setRandomWeights];
  if (!(neura = [neura createEnd]))
    [InvalidCombination raiseEvent: "NN not created"];
  
  // Loop variables
  inp = (float *)xcalloc (numNeurons, sizeof (float));
  oldOut = (float *)xcalloc (numNeurons, sizeof (float));
  out = (float *)xcalloc (numNeurons, sizeof (float));

  while ([controlPanel getState] !=  ControlStateQuit)
    {
      while ([controlPanel getState] != ControlStateRunning)
        [actionCache waitForControlEvent];

      [actionCache doTkEvents];
      [actionCache deliverActions];
      
      for (j = 0; j < numNeurons; j++)
        inp[j] = (float)[uniformDblRand getDoubleWithMin:-1.0L withMax: 1.0L];
      
      // Clamp initial values
      [neura clamp: inp];
      [neura getActivation: out];
      
      // Clamp to 0 and loop
      for (j = 0; j < numNeurons; j++)
        inp[j] = 0.0;
      [neura clamp: inp];
      while ((oldOut[0]!= out[0]) && (oldOut[1] != out[1]))
        {
          [ptData resetData];
          for (j = 0 ;j < numNeurons; j ++)
            oldOut[j] = out[j];
          [ptData addX: out[0] Y: out[1] ];
          [wgtData addX: out[0] Y: out[1] ];
          [neura getActivation: out];
        }
      
      //	[wgtGraph destroyElement: wgtData];  
      wgtData = [wgtGraph createElement];
      [wgtData setLabel: ""];
      [wgtData setColor: "Red"];
      
      // Plot attractors
      [attrData addX: out[0] Y: out[1]];
    }
  xfree (inp);
  xfree (out);
  xfree (oldOut);
  exit (0);
}




