// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.


#include "Hebb.h"

@implementation Hebb

//-----------------------------------------------------
//            Learning and recalling functions
//-----------------------------------------------------

//-----------------------------------------------------
- (unsigned )feedForward: (float *)inpVec
{
// dimension should be the same than the input layer

    unsigned i, j, maxOp = 0;
    float maxVal = -1e22;	// Smallest number around
    memcpy( inpLy, inpVec, inpSize*sizeof(float) );

    for ( i = 0; i < numNeurons; i++ ) {
	opLy[i] = 0;		// Reset output layer
	for ( j = 0; j < inpSize; j++ ) {
	    opLy[i] += Wgts[ i*inpSize + j ]*inpVec[j];
	}

	if ( opLy[i] > maxVal ) {
	    maxOp = i;
	    maxVal = opLy[i];
	}
    }
    return maxOp;
}


//------------------------------------------------------
-            train {
//Pay no atention to whatever... pure hebbian
//No renormalization
    int sgn;
    unsigned i, j;
    for ( i = 0; i < numNeurons; i++ ) {
	for ( j = 0; j < inpSize; j++ ) {
	    sgn = (opLy[i]*inpLy[j] > 0 )?1:-1;
	    Wgts[ i*inpSize + j ]+= alpha*sgn ;
	}
    }    
    return self;
}

@end
