// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// Space of ant objects.
// value 0 means no object, values 1 - n are objects.

#import "SortSpace.h"
#import <random.h>

// FAST also affects drawSelfOn:
#define FAST
#ifdef FAST
# define ObjectAt(x,y) ((int)(*(discrete2dSiteAt(lattice, offsets, x, y))))
#else
# define ObjectAt(x,y) [self getValueAtX: (x) Y: (y)]
#endif

@implementation SortSpace
- setDensity: (float)f
{
  density = f;
  return self;
}

- setNumTypes: (int)n
{
  numTypes = n;
  return self;
}

// finalize creation: randomize world.
- createEnd
{
  int x, y;
  
  if (xsize == 0 || ysize == 0 || numTypes == 0)
    {
      [InvalidCombination raiseEvent: "SortSpace not initialized correctly\n"];
      return nil;
    }

  [super createEnd];
  
  for (x = 0; x < xsize; x++)
    for (y = 0; y < ysize; y++)
      if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < density)
        [self putValue: [uniformIntRand getIntegerWithMin: 1 withMax: numTypes] atX: x Y: y];
  
  return self;
}

// pick up an object.
- (SortParcel)pickupAtX: (int)x Y: (int)y
{
  SortParcel object;
  
  object = [self getValueAtX: x Y: y];
  if (object)
    [self putValue: 0 atX: (int) x Y: (int) y];
  return object;
}

// drop an object. returns true if the drop was successful.
- (BOOL)drop: (SortParcel)object AtX: (int)x Y: (int)y
{
  SortParcel alreadyThere;
  
  alreadyThere = [self getValueAtX: x Y: y];
  if (alreadyThere)
    return 0;
  else
    {
      [self putValue: object atX: x Y: y];
      return 1;
    }
}

- (int)num8NeighboursAtX: (int)x Y: (int)y Type: (SortParcel)type
{
  int count;
  int xminusone, xplusone, yminusone, yplusone;

  xminusone = (x - 1) >= 0 ? (x - 1) : (xsize - 1);
  xplusone = (x + 1) < xsize ? (x + 1) : 0;
  yminusone = (y - 1) >= 0 ? (y - 1) : (ysize - 1);
  yplusone = (y + 1) < ysize ? (y + 1) : 0;

  count = 0;
  count += ObjectAt (xminusone, yminusone) == type ? 1 : 0;
  count += ObjectAt (x,         yminusone) == type ? 1 : 0;
  count += ObjectAt (xplusone,  yminusone) == type ? 1 : 0;

  count += ObjectAt (xminusone, y        ) == type ? 1 : 0;
  count += ObjectAt (xplusone,  y        ) == type ? 1 : 0;

  count += ObjectAt (xminusone, yplusone ) == type ? 1 : 0;
  count += ObjectAt (x,         yplusone ) == type ? 1 : 0;
  count += ObjectAt (xplusone,  yplusone ) == type ? 1 : 0;

  return count;
}

- (int)num4NeighboursAtX: (int)x Y: (int)y Type: (SortParcel)type
{
  int count;
  int xminusone, xplusone, yminusone, yplusone;
  
  xminusone = (x - 1) >= 0 ? (x - 1) : (xsize - 1);
  xplusone = (x + 1) < xsize ? (x + 1) : 0;
  yminusone = (y - 1) >= 0 ? (y - 1) : (ysize - 1);
  yplusone = (y + 1) < ysize ? (y + 1) : 0;

  count = 0;
  count += ObjectAt(x,         yminusone) == type ? 1 : 0;
  count += ObjectAt(xminusone, y        ) == type ? 1 : 0;
  count += ObjectAt(xplusone,  y        ) == type ? 1 : 0;
  count += ObjectAt(x,         yplusone ) == type ? 1 : 0;

  return count;
}

// colour: the object + 2 (colour 0 and 1 used elsewhere). God, this is evil.
- drawSelfOn: (id <Raster>)r
{
  int x, y;
  IMP drawImp;

  drawImp = [(id)r methodFor: @selector (drawPointX:Y:Color:)]; // cache lookup
  
  for (y = 0; y < ysize; y++)
    for (x = 0; x < xsize; x++)
      if (ObjectAt(x,y))
        {
          unsigned char color;
          
          color = (unsigned char)((int) ObjectAt(x,y) + 2);
#ifdef FAST      
          (void) *drawImp(r, @selector(drawPointX:Y:Color:), x, y, color);
#else
          [r drawPointX: x Y: y Color: color];
#endif
        }
  return self;
}

@end
