#import <math.h>
#import "SeedSpace.h"

@implementation SeedSpace

+createBegin: aZone {
  SeedSpace * obj ;

  obj = [super createBegin: aZone] ;
  obj->maxSeeds = 100 ;
  obj->deathRate = 1.0 ;
  return obj ;
}

-setMaxSeeds: (int) aValue {
  maxSeeds = aValue ;
  return self ;
}

-setDeathRate: (double) d {
  deathRate = d;
  return self;
}

-initializeLattice {
  unsigned x, y;

  for (y = 0; y < ysize; y++)
    for (x = 0; x < xsize; x++) {
      *(discrete2dSiteAt(lattice, offsets, x, y)) = 0 ;
    }

  return self;
}

-createEnd {
  [super createEnd];
  [self initializeLattice];
  return self;
}

-stepRule {
  unsigned x, y;
  int test ;
  double newVal ;

  for (x = 0; x < xsize; x++)
    for (y = 0; y < ysize; y++) {
      test = (int) *(discrete2dSiteAt(lattice, offsets, x, y)) ;
      if(test){
        newVal = (double) test ;
        newVal *= deathRate ; 
        *(discrete2dSiteAt(lattice, offsets, x, y)) = 
          (id) ((int) floor(newVal));
      }
    }
  return self;
}

-addSeeds: (int) seedNum X: (int) x Y: (int) y {
  int seedsHere;

  seedsHere = (int) *(discrete2dSiteAt(lattice, offsets, x, y)) ;

  if (seedNum <= maxSeeds - seedsHere)
    seedsHere += seedNum;
  else
    seedsHere = maxSeeds;
        
  *(discrete2dSiteAt(lattice, offsets, x, y)) = 
          (id) seedsHere ;

  return self;
}

-(int) seedsAtX: (int) theX Y: (int) theY {
  return (int) *(discrete2dSiteAt(lattice, offsets, theX, theY)) ;
}

@end
