// **********************************
// from basic code to apps: keep this file unchanged
// **********************************

// Agent.m                                        

#import "Agent.h"

@implementation Agent

// we set the agent number and establish whether this agent (this neural
// network) has to read previously saved weights
- setNumber: (int) n andSetReadWeightsFromFile: (int) rw
{
   number = n;
   readWeightsFromFile = rw;
   return self;
}

- (int) getNumber
{
  return number;
}

// the ruleMaster address used by the agent
- setRuleMaster: rm
{
  ruleMaster = rm;
  return self;
}
// the agent data warehouse, where agent internal data are stored
- setDataWarehouse: dw
{
  myDataWarehouse = dw;
  return self;
}

// the agent interface, used by the Observer to dialogue with
// the agent and by the agent itself to build its CT data
- setInterface: inf
{
  myInterface = inf;
  return self;
}

// data on the terminal
- setDisplayDataWhileRunning: (int) d
{
  agentsAreDisplayingData = d;
  return self;
}


- getDataWarehouse
{
  return myDataWarehouse;
}

- getInterface
{
  return myInterface;
}


- createEnd
{

   [super createEnd];

   // to obtain static data
   inputNodeNumber= [myDataWarehouse getInputNodeNumber];
   hiddenNodeNumber=[myDataWarehouse getHiddenNodeNumber];
   outputNodeNumber=[myDataWarehouse getOutputNodeNumber];
   patternNumberInVerificationSet=[myDataWarehouse
                                     getPatternNumberInVerificationSet];

   // to obtain the pointers to the obiects containing the following
   // matrixes
   outputVerificationMatrix=[myDataWarehouse
                                     getOutputVerificationMatrix];
   targetVerificationMatrix=[myDataWarehouse
                                     getTargetVerificationMatrix];
   minmax=[myDataWarehouse           getMinmax];

   // to order- if necessary - the agent DataWarehouse
   // (myDataWarehouse) to read the weights of the artificial neural
   // network from a file; the name of the file contains the agent number
   if (readWeightsFromFile == 1)
      [myDataWarehouse readWeightsFromFileOfAgentNumber: number];

   return self;
}

- step1 // the schedule activates thre steps for each agent in each
        // time cycle; this first step is a preparatory one; we use
        // it only in the CT scheme
{
   // to check for Cross Target (CT) internal inputs production

   if(patternNumberInVerificationSet<0)
   {
    [myInterface setCT_Inputs];

    // this run of ruleMaster (StepA) is necessary TO PRODUCE THE OUTPUTS OF
    // THE AGENTS; THESE OUTPUTS CAN BE NECESSARY IN BUILDING CT TARGETS
    // BASED ON THE BEHAVIOUR OF OTHER AGENTS
    [ruleMaster
    applyRulesToInputOutputValuesInDataWarehouseStepA: myDataWarehouse];
   }

   return self;
}

- step2
{
   int i, j, pN;


   // in CT scheme we can now generate the targets, that may be based on the
   // outputs generated in step1
   if(patternNumberInVerificationSet<0)
    [myInterface setCT_Targets];

   // this is the second run of ruleMaster (always StepA) in CT scheme, but
   // it is the first if we are not adopting the CT scheme

   [ruleMaster
   applyRulesToInputOutputValuesInDataWarehouseStepA: myDataWarehouse];

   // errors

   // conventional back propagation error (sum of all the output units in
   // all the patterns, i.e. epoch error, divided by the number of patterns)
   // the error is also conventionally divided by 2
   backPropagationErrorInVerificationSet=
                      [ruleMaster getBackPropagationErrorInVerificationSet];

   // proportional error (aritmetic mean of all the output units in
   // all the patterns, i.e. epoch error)
   // this error is the ratio obtained dividing the abs value of
   // the difference of each target minus each output by one half of the
   // difference of the internal max value {i.e. [minmax R:3 C:j]} minus
   // the internal min value {i.e. [minmax R:2 C:j]} (the metrics is here
   // that of the internal values; anyway, when calculating a ratio the
   // metrics is not relevant)
   // we have  max error=2; min error=0
   proportionalErrorInVerificationSet   =
                      [ruleMaster getProportionalErrorInVerificationSet];


   if(agentsAreDisplayingData==1)
   {

   printf("\nAgent # %d\n",number);

   pN=patternNumberInVerificationSet;
   if(patternNumberInVerificationSet<0)pN*=-1; // if CT

   for (i=0; i<pN; i++)
   for (j=0;j<outputNodeNumber;j++)
       printf("pattern # %d;%d  output %7.3f target %7.3f\n",i+1, j+1,
       [outputVerificationMatrix R: i C: j asExternalValueUsing: minmax
                               withShift: inputNodeNumber],
       [targetVerificationMatrix R: i C: j asExternalValueUsing: minmax
                               withShift: inputNodeNumber]);

  printf("Conventional back propagation error in verification set %8.3f\n",
                                     backPropagationErrorInVerificationSet);
  printf("Proportional error in verification set                     %5.3f\n",
                                     proportionalErrorInVerificationSet);
   }

   return self;
}

- step3
{

   // learning 
   [ruleMaster
   applyRulesToInputOutputValuesInDataWarehouseStepB: myDataWarehouse];

   // errors (see above)

   backPropagationErrorInTrainingSet=
                      [ruleMaster getBackPropagationErrorInTrainingSet];
   proportionalErrorInTrainingSet   =
                      [ruleMaster getProportionalErrorInTrainingSet];

   return self;
}

-(float) getBackPropagationErrorInVerificationSet
{
  return backPropagationErrorInVerificationSet;
}

-(float) getProportionalErrorInVerificationSet
{
  return proportionalErrorInVerificationSet;
}

-(float) getBackPropagationErrorInTrainingSet
{
  return backPropagationErrorInTrainingSet;
}

-(float) getProportionalErrorInTrainingSet
{
  return proportionalErrorInTrainingSet;
}

- save // to save weights
{
   int i, j, pN;
   id <OutFile> tempOutFile;
   char name [40];

   //wih
   sprintf(name,"agent%d.wih",number);

// tempOutFile=[OutFile create:[self getZone]withName: name];// 1.3.1 or 1.4.1
   tempOutFile=[OutFile create:[self getZone]setName:  name];// 2.0.1
    
   for (i=0;i<hiddenNodeNumber;i++)
   {
   for (j=0;j<inputNodeNumber+1;j++)
     [tempOutFile putFloat: [[myDataWarehouse getWih] R:i C:j]];
     [tempOutFile putNewLine];
   }

   [tempOutFile drop];

   //who
   sprintf(name,"agent%d.who",number);

// tempOutFile=[OutFile create:[self getZone]withName: name];// 1.3.1 or 1.4.1
   tempOutFile=[OutFile create:[self getZone]setName:  name];// 2.0.1
    
   for (i=0;i<outputNodeNumber;i++)
   {
   for (j=0;j<hiddenNodeNumber+1;j++)
     [tempOutFile putFloat: [[myDataWarehouse getWho] R:i C:j]];
     [tempOutFile putNewLine];
   }

   [tempOutFile drop];

   //outputVerificationMatrix
   sprintf(name,"agent%d.outputVerificationMatrix",number);

// tempOutFile=[OutFile create:[self getZone]withName: name];// 1.3.1 or 1.4.1
   tempOutFile=[OutFile create:[self getZone]setName:  name];// 2.0.1
   pN = patternNumberInVerificationSet;
   if (pN < 0) pN = -1*pN;


   for (i=0;i<pN;i++)
   {
   for (j=0;j<outputNodeNumber;j++)
     [tempOutFile putFloat: [[myDataWarehouse
      getOutputVerificationMatrix] R:i C:j asExternalValueUsing: minmax
                                           withShift: inputNodeNumber]];
     [tempOutFile putNewLine];
   }

   [tempOutFile drop];

   return self;
}

@end

