// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ObserverSwarm.h

#import "ModelSwarm.h"
#import "Agent.h"

// +++++++ start
#import "ConsumerInterface.h"
#import "ProducerInterface.h"  // NB. We have to include the specific
                               // interfaces for the agents
                               // related to the graphics below
// +++++++ end

#import <simtoolsgui/GUISwarm.h>
#import <analysis.h> // to use EZgraph


@interface ObserverSwarm: GUISwarm
{
  int displayFrequency, patternNumberInVerificationSet;
                                        // alternatively used as
                                        // freq. of update in the
                                        // Observer widgets

  id displayActions;                    // schedule data structures
  id displaySchedule;

  id <EZGraph> errorGraphInVerificationSet; // to display the error while
                                            // verifying
  int displayErrorGraphInVerificationSet;

  id <EZGraph> errorGraphInTrainingSet;     // to display the error while
                                            // learning
  int displayErrorGraphInTrainingSet;

// +++++++ start
  id <EZGraph> priceGraphInVerificationSet; // to display the prices
  int displayPriceGraphInVerificationSet;

  id <EZGraph> consumerAgentA_Graph, producerAgentA_Graph; // to display
                                                           // specific agents
// +++++++ end

  int stopAtEpochGroupNumber, numberOfTheConsumerAgentA_ToBeObservedDirectly,
                              numberOfTheProducerAgentA_ToBeObservedDirectly;

  ModelSwarm *modelSwarm;               // the Swarm containing our neural
                                        // networks

// +++++++ start
  Agent      * consumerAgentA; // an agent that may be accessed directly,
                               // if any
  ConsumerInterface  * consumerAgentA_Interface;
                               // the interface of an agent that has to be
                               // accessed
  Agent      * producerAgentA; // an agent that may be accessed directly,
                               // if any
  ProducerInterface  * producerAgentA_Interface;
                               // the interface of an agent that has to be
                               // accessed
// +++++++ end

}

+ createBegin: aZone;
- createEnd; 
- buildObjects;
- buildActions;
- activateIn: swarmContext;

- checkToStop;

@end

