// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ObserverSwarm.m

#import "ObserverSwarm.h"
#import <activity.h>
#import <simtoolsgui.h>

@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;

  // Superclass createBegin to allocate ourselves.

  obj = [super createBegin: aZone];

  // Fill in the relevant parameters.

//  obj->displayFrequency = 1;  // displayFrequency is not used here in
                                // a traditional way
  obj->displayErrorGraphInVerificationSet = 1; // 1=yes, 0=not
  obj->displayErrorGraphInTrainingSet     = 1; // 1=yes, 0=not

// +++++++ start
  obj->displayPriceGraphInVerificationSet = 1; // 1=yes, 0=not
// +++++++ end

// +++++++ start
  obj->numberOfTheConsumerAgentA_ToBeObservedDirectly = 1; // we can choose
  obj->numberOfTheProducerAgentA_ToBeObservedDirectly = 1; // the agent
// +++++++ end

  obj->stopAtEpochGroupNumber             = 0; // to stop the program and to
                                               // save the weights (if != 0)

  // to build a customized probe map
  // without a probe map, the default is to show all variables and messages
  // here we choose to customize the appearance of the probe, to give a nicer
  // interface

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add variables to be probed

  [probeMap addProbe: [probeLibrary getProbeForVariable: 
                                      "displayErrorGraphInVerificationSet"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: 
                                      "displayErrorGraphInTrainingSet"
                                    inClass: [self class]]];

// +++++++ start
  [probeMap addProbe: [probeLibrary getProbeForVariable:
                                      "displayPriceGraphInVerificationSet"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: 
                                      "numberOfTheConsumerAgentA_ToBeObservedDirectly"
                                    inClass: [self class]]];
  [probeMap addProbe: [probeLibrary getProbeForVariable: 
                                      "numberOfTheProducerAgentA_ToBeObservedDirectly"
                                    inClass: [self class]]];
// +++++++ end

  [probeMap addProbe: [probeLibrary getProbeForVariable:
                                      "stopAtEpochGroupNumber"
                                    inClass: [self class]]];

  // set our custom probeMap into the probeLibrary as the default probe for
  // the ObserverSwarm class

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

- createEnd
{
  return [super createEnd];
}


- buildObjects
{
  [super buildObjects];

  modelSwarm = [ModelSwarm create: self];

  // to create probe objects on the model and the observer (self, here)
  // ARCHIVED to allow the "Save" button to operate

  CREATE_ARCHIVED_PROBE_DISPLAY (modelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  // we pause here to allow the parameters to be changed.

  [controlPanel setStateStopped];


  // The system will wait until the user hits "Start" or "Next"
  // on the control panel

  [modelSwarm buildObjects];

  // Observer display objects.

// +++++++ start

  if (displayPriceGraphInVerificationSet == 1)
  {
  // price graph
  priceGraphInVerificationSet = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (priceGraphInVerificationSet);
                                                    // to allow "Save"
  [priceGraphInVerificationSet setTitle: "Valid Prices and Mean Quantity."];
  [priceGraphInVerificationSet setAxisLabelsX:
   "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Price"];
  priceGraphInVerificationSet = [priceGraphInVerificationSet createEnd];

  [priceGraphInVerificationSet createAverageSequence:
                               "Mean price"
                               withFeedFrom: [modelSwarm getInterfaceList]
                  andSelector: M(getActualP_target)];

  [priceGraphInVerificationSet createMinSequence:
                               "Min price"
                               withFeedFrom: [modelSwarm getInterfaceList]
                  andSelector: M(getActualP_target)];

  [priceGraphInVerificationSet createMaxSequence:
                               "Max price"
                               withFeedFrom: [modelSwarm getInterfaceList]
                  andSelector: M(getActualP_target)] ;

  [priceGraphInVerificationSet createAverageSequence:
                               "Mean Q/10"
                               withFeedFrom: [modelSwarm getInterfaceList]
                  andSelector: M(getActualQ_target_devidedBy10)] ;


  }

// +++++++ end

  if (displayErrorGraphInVerificationSet == 1)
  {
  // error graph
  errorGraphInVerificationSet = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (errorGraphInVerificationSet);
                                                    // to allow "Save"
  [errorGraphInVerificationSet setTitle: "Errors in verification set."];
  [errorGraphInVerificationSet setAxisLabelsX:
   "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Error"];
  errorGraphInVerificationSet = [errorGraphInVerificationSet createEnd];

  [errorGraphInVerificationSet createAverageSequence:
                               "Mean bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInVerificationSet)];

  [errorGraphInVerificationSet createMinSequence:
                               "Min bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInVerificationSet)];

  [errorGraphInVerificationSet createMaxSequence:
                               "Max bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInVerificationSet)] ;

  [errorGraphInVerificationSet createAverageSequence:
                               "Mean prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInVerificationSet)] ;
  [errorGraphInVerificationSet createMinSequence:
                               "Min prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInVerificationSet)] ;

  [errorGraphInVerificationSet createMaxSequence:
                               "Max prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInVerificationSet)] ;

  }

  if (displayErrorGraphInTrainingSet == 1)
  {
  // error graph
  errorGraphInTrainingSet = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (errorGraphInTrainingSet);
                                                    // to allow "Save"
  [errorGraphInTrainingSet setTitle: "Errors in training set."];
  [errorGraphInTrainingSet setAxisLabelsX:
   "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Error"];
  errorGraphInTrainingSet = [errorGraphInTrainingSet createEnd];

  [errorGraphInTrainingSet createAverageSequence:
                               "Mean bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInTrainingSet)];

  [errorGraphInTrainingSet createMinSequence:
                               "Min bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInTrainingSet)];

  [errorGraphInTrainingSet createMaxSequence:
                               "Max bp error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getBackPropagationErrorInTrainingSet)] ;

  [errorGraphInTrainingSet createAverageSequence:
                               "Mean prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInTrainingSet)] ;
  [errorGraphInTrainingSet createMinSequence:
                               "Min prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInTrainingSet)] ;

  [errorGraphInTrainingSet createMaxSequence:
                               "Max prop error"
                               withFeedFrom: [modelSwarm getList]
                  andSelector: M(getProportionalErrorInTrainingSet)] ;

  }


  // inputs, outputs and targets for one or more agents (via EZGraph), needed
  // also to save the values in a file; we can reproduce this widget to
  // obtain the graph for further agents

// +++++++ start
  // a check
  if([modelSwarm getConsumerNumber] == 0)
                            numberOfTheConsumerAgentA_ToBeObservedDirectly=0;

// a consumer
  // this may be 0 if we do not have any agent (above) or if we choose to
  // have no display
  if (numberOfTheConsumerAgentA_ToBeObservedDirectly > 0)
                                            // the value comes from probe
  {
  // the address of the chosen agent

  [[modelSwarm getConsumerArrayIndex] setOffset:
                                   numberOfTheConsumerAgentA_ToBeObservedDirectly-1];
  consumerAgentA = [[modelSwarm getConsumerArrayIndex] get];
  consumerAgentA_Interface = [consumerAgentA getInterface];


   // agent A graph
   consumerAgentA_Graph = [EZGraph createBegin: [self getZone]];
   SET_WINDOW_GEOMETRY_RECORD_NAME (consumerAgentA_Graph); // to allow "Save"
   [consumerAgentA_Graph setTitle: "Consumer A data."];
   [consumerAgentA_Graph setAxisLabelsX:
    "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Value"];
   consumerAgentA_Graph = [consumerAgentA_Graph createEnd];

// the following setting doubles the number of messages that are sent
// by createSequence; so the counters in the specific Interface proceed
// by 0.5 steps
   [consumerAgentA_Graph setFileOutput: (BOOL) 1];
                                           // to send the data also to a file

   [consumerAgentA_Graph createSequence: "cActualP_out"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getActualP_out)];
   [consumerAgentA_Graph createSequence: "cActualP_target"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getActualP_target)];
   [consumerAgentA_Graph createSequence: "cActualQ_out"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getActualQ_out)];
   [consumerAgentA_Graph createSequence: "cActualQ_target"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getActualQ_target)];
   [consumerAgentA_Graph createSequence: "cExpenditure_out"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getExpenditure_out)];
   [consumerAgentA_Graph createSequence: "cExpenditure_target"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getExpenditure_target)];
   [consumerAgentA_Graph createSequence: "cRequirement_out"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getRequirement_out)];
   [consumerAgentA_Graph createSequence: "cRequirement_target"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getRequirement_target)];
   [consumerAgentA_Graph createSequence: "cP_out"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getP_out)];
   [consumerAgentA_Graph createSequence: "cP_target"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getP_target)];
   [consumerAgentA_Graph createSequence: "cQ_out"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getQ_out)];
   [consumerAgentA_Graph createSequence: "cQ_target"
                                 withFeedFrom: consumerAgentA_Interface
                                 andSelector: M(getQ_target)];

  }


  // a check
  if([modelSwarm getProducerNumber] == 0)
                            numberOfTheProducerAgentA_ToBeObservedDirectly=0;

//a producer
  // this may be 0 if we do not have any agent (above) or if we choose to
  // have no display
  if (numberOfTheProducerAgentA_ToBeObservedDirectly > 0)
                                            // the value comes from probe
  {
  // the address of the chosen agent

  [[modelSwarm getProducerArrayIndex] setOffset:
                                   numberOfTheProducerAgentA_ToBeObservedDirectly-1];
  producerAgentA = [[modelSwarm getProducerArrayIndex] get];
  producerAgentA_Interface = [producerAgentA getInterface];

   // agent A graph
   producerAgentA_Graph = [EZGraph createBegin: [self getZone]];
   SET_WINDOW_GEOMETRY_RECORD_NAME (producerAgentA_Graph); // to allow "Save"
   [producerAgentA_Graph setTitle: "Producer A data."];
   [producerAgentA_Graph setAxisLabelsX:
    "(Epoch Groups) x (# of p. in ver. set) - 1" Y: "Value"];
   producerAgentA_Graph = [producerAgentA_Graph createEnd];

// the following setting doubles the number of messages that are sent
// by createSequence; so the counters in the specific Interface proceed
// by 0.5 steps
   [producerAgentA_Graph setFileOutput: (BOOL) 1];
                                           // to send data also to a file

   [producerAgentA_Graph createSequence: "pActualP_out"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getActualP_out)];
   [producerAgentA_Graph createSequence: "pActualP_target"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getActualP_target)];
   [producerAgentA_Graph createSequence: "pActualQ_out"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getActualQ_out)];
   [producerAgentA_Graph createSequence: "pActualQ_target"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getActualQ_target)];
   [producerAgentA_Graph createSequence: "pRevenue_out"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getRevenue_out)];
   [producerAgentA_Graph createSequence: "pRevenue_target"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getRevenue_target)];
   [producerAgentA_Graph createSequence: "pProductionStream_out"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getProductionStream_out)];
   [producerAgentA_Graph createSequence: "pProductionStream_target"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getProductionStream_target)];
   [producerAgentA_Graph createSequence: "pP_out"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getP_out)];
   [producerAgentA_Graph createSequence: "pP_target"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getP_target)];
   [producerAgentA_Graph createSequence: "pQ_out"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getQ_out)];
   [producerAgentA_Graph createSequence: "pQ_target"
                                 withFeedFrom: producerAgentA_Interface
                                 andSelector: M(getQ_target)];
  }
// +++++++ end


  return self;
}

- buildActions
{
  int k;
  [super buildActions];

  // model schedule.

  [modelSwarm buildActions];

  // ActionGroup for Observer display
  // it gets the number of steps in each cycle, required to display
  // all the patterns of an agent (in its verification set)
  patternNumberInVerificationSet=[modelSwarm
                                  getPatternNumberInVerificationSet];

  displayActions = [ActionGroup create: self];

  // to update probes
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  [displayActions createActionTo: errorGraphInVerificationSet
                                                           message: M(step)];
  [displayActions createActionTo: errorGraphInTrainingSet  message: M(step)];
  [displayActions createActionTo: priceGraphInVerificationSet
                                                           message: M(step)];
  [displayActions createActionTo: self message: M(checkToStop)];

  // Display schedule. Note that the repeat interval is set by our
  // own Swarm data structure. The display is frequently the slowest part of a
  // simulation, when it is redraw less frequently things are faster


  displaySchedule = [Schedule createBegin: self];

  // the if condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
  [displaySchedule setRepeatInterval: 
                       -1*patternNumberInVerificationSet];
  else
  [displaySchedule setRepeatInterval:
                          patternNumberInVerificationSet]; // note frequency!

  displaySchedule = [displaySchedule createEnd];

  if (patternNumberInVerificationSet < 0)
  [displaySchedule at: -1*patternNumberInVerificationSet-1
                           createAction: displayActions];
  else
  [displaySchedule at:    patternNumberInVerificationSet-1
                           createAction: displayActions];


// +++++++ start
  if (numberOfTheConsumerAgentA_ToBeObservedDirectly > 0)
  {
  // the if condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
   for (k=0;k<=-1*patternNumberInVerificationSet-1;k++)
       [displaySchedule at: k
       createActionTo: consumerAgentA_Graph message: M(step)];
  else
   for (k=0;k<=   patternNumberInVerificationSet-1;k++)
       [displaySchedule at: k
       createActionTo: consumerAgentA_Graph message: M(step)];
   }


  if (numberOfTheProducerAgentA_ToBeObservedDirectly > 0)
  {
  // the if condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
   for (k=0;k<=-1*patternNumberInVerificationSet-1;k++)
       [displaySchedule at: k
       createActionTo: producerAgentA_Graph message: M(step)];
  else
   for (k=0;k<=   patternNumberInVerificationSet-1;k++)
       [displaySchedule at: k
       createActionTo: producerAgentA_Graph message: M(step)];
   }
// +++++++ end

  return self;
}

- activateIn: swarmContext
{
// activateIn: - to activate the schedules to make them ready to run.

  [super activateIn: swarmContext];

  [modelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

  // to check for the stopping conditions
- checkToStop
{

  // if stopAtEpochGroupNumber is left to 0, the program will never stop

  if (stopAtEpochGroupNumber == [modelSwarm getCurrentEpochGroup])
  {
      printf("Stopping at epoch group number %4d and\nsaving files.\n",
                                [modelSwarm getCurrentEpochGroup]);

      // agents are receiving the order to save their data
      [[modelSwarm getList] forEach: M(save)];
                                          
      // we can restart by pressing "Start" or "Next"
      [controlPanel setStateStopped];
  }

  return self;
}


@end


