/* 
  NeighborhoodProtocol.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  08-OCT-1996

*/

#import <objectbase.h>

#import "neighbor.h"

@protocol NeighborhoodProtocol

/* The precise meanings of -next and -previous are specific
   to a particular neighborhood class.

  The -random method picks a random neighbor (with 
  uniform probability function) and returns it.  */

-(BOOL) isValidNeighborCode: (neighbor_t) inNeighbor;
-(neighbor_t) getNext: (neighbor_t) inNeighbor;
-(neighbor_t) getPrevious: (neighbor_t) inNeighbor;
-(neighbor_t) getOpposite: (neighbor_t) inNeighbor;
-(neighbor_t) getRandom;
-(neighbor_t) getRandomExcluding: (neighbor_t) inNeighbor;

@end
